set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9853968';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-8-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0002',
      '12320241',
      69,
      64.590735,
      '4341401',
      25.791538,
      NULL,
      3,
      0,
      '303204',
      0,
      NULL,
      52.887291,
      53.661002,
      1.925830,
      NULL,
      0,
      1.361945,
      0,
      0,
      1,
      1,
      NULL,
      1.246734,
      1,
      0.109672,
      NULL,
      0.146502,
      4,
      2,
      0,
      NULL,
      4.127386,
      1.591835,
      2.115055,
      0.504826,
      1.316025,
      1.820815,
      4,
      1,
      0.754045,
      5.782412,
      3,
      1.788851,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0.199059,
      NULL,
      0.380045,
      1.561309,
      2,
      NULL,
      0,
      3,
      0.574368,
      3,
      1,
      2,
      0,
      2,
      3.862804,
      2.508621,
      NULL,
      0.254379,
      1.225269,
      3,
      7.308197,
      0,
      NULL,
      3,
      1.605875,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.245766,
      0.418635,
      2.488404,
      1,
      2.737715,
      NULL,
      0,
      1,
      3.109201,
      0,
      1,
      1.765935,
      1.662048,
      5,
      0.682153,
      0.007735,
      NULL,
      1.822579,
      1.170963,
      NULL,
      1.462942,
      NULL,
      1.104267,
      0.821425,
      0,
      1.857310,
      NULL,
      2.617609,
      NULL,
      NULL,
      NULL,
      NULL,
      3.550584,
      1,
      3.231255,
      NULL,
      3,
      7,
      NULL,
      NULL,
      6.512659,
      5.991258,
      0.670455,
      5.344277,
      2,
      NULL,
      1,
      1,
      3.287625,
      NULL,
      NULL,
      2.618067,
      0.610310,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      NULL,
      0,
      1.493585,
      1.439223,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      0.764430,
      1.663682,
      4.548343,
      1,
      0,
      1,
      0.341459,
      5.427954,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      4.651231,
      NULL,
      2.320018,
      2.804042,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2.488817,
      3,
      2.871805,
      2,
      0,
      NULL,
      1.624171,
      NULL,
      0,
      1.461824,
      1.480676,
      1,
      0.302273,
      1,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.897761,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '23024',
      NULL,
      '',
      NULL,
      '',
      '',
      NULL,
      0.921481,
      '',
      NULL,
      '',
      5.819085,
      4,
      1.168163,
      1,
      0,
      0,
      0.171430,
      2,
      0);
commit;
end;
/


