set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9853968';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-12-22 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0312',
      '43013330',
      NULL,
      37.540244,
      '2103442',
      46.207461,
      4,
      2.140970,
      0,
      '110240',
      1.028187,
      ' 0-13-1999',
      27.027361,
      NULL,
      0,
      NULL,
      0.098983,
      1,
      1.456854,
      1,
      1,
      1.746359,
      NULL,
      3,
      1,
      0,
      1,
      0.118100,
      1,
      9,
      NULL,
      0,
      4,
      1,
      0,
      0.978374,
      1.463384,
      NULL,
      9.497805,
      NULL,
      0.517440,
      4.628970,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.789131,
      1,
      0.844220,
      2,
      1.789978,
      0.461920,
      2.612697,
      0,
      0,
      0.786633,
      NULL,
      3.140471,
      0.944798,
      1,
      0.764807,
      3,
      NULL,
      3.416386,
      NULL,
      1,
      0.408844,
      0,
      2.753700,
      0,
      0,
      3,
      1,
      NULL,
      NULL,
      1.975754,
      NULL,
      NULL,
      NULL,
      0.763905,
      1.220649,
      NULL,
      NULL,
      1,
      2.978408,
      0,
      0.513995,
      1,
      1.492767,
      0,
      1.068389,
      NULL,
      0.993539,
      NULL,
      0,
      0,
      1.360913,
      NULL,
      0.449896,
      1,
      NULL,
      NULL,
      3,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.607599,
      2.971415,
      2,
      1.515480,
      3.617847,
      NULL,
      NULL,
      5.892159,
      7.724744,
      1.015202,
      NULL,
      NULL,
      4,
      0.776945,
      3,
      0,
      1,
      0.551941,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      0.334632,
      1,
      NULL,
      1.035401,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.349014,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.435253,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.937861,
      1.502786,
      0.559322,
      7.845439,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1.439707,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      1.070424,
      3.948423,
      3,
      NULL,
      3.008273,
      3.691327,
      0.882388,
      0,
      0.999721,
      0,
      NULL,
      1,
      0,
      1.181715,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.050296,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3.807792,
      '14411',
      '',
      '',
      0.438266,
      '',
      '',
      NULL,
      0.016148,
      '',
      '',
      '',
      2,
      4,
      2.506217,
      3,
      3.015251,
      2,
      2,
      2.922016,
      0.656160);
commit;
end;
/


