set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7504246';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-3-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '4',
      NULL,
      NULL,
      NULL,
      13.372435,
      6,
      3.669069,
      1,
      '044224',
      NULL,
      NULL,
      23.899433,
      NULL,
      1.284498,
      NULL,
      3,
      0.816286,
      2,
      1.457267,
      1,
      3,
      NULL,
      0,
      1,
      NULL,
      2,
      0.626900,
      NULL,
      0,
      NULL,
      1,
      2.989656,
      1.234445,
      0,
      1.070196,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0.007240,
      0.762642,
      1.945019,
      NULL,
      NULL,
      1.148787,
      NULL,
      NULL,
      2.944937,
      0,
      0,
      1,
      0.782343,
      0,
      0.325972,
      NULL,
      0.840417,
      0.184521,
      0.656329,
      1,
      0.216927,
      1.658043,
      1,
      1.331865,
      0,
      1.322821,
      NULL,
      NULL,
      NULL,
      0,
      6.165005,
      1,
      1,
      NULL,
      0.972036,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.381106,
      1.248607,
      0.589700,
      1,
      NULL,
      1,
      NULL,
      1,
      0,
      1,
      0.638228,
      1.067790,
      1.432691,
      1,
      NULL,
      0,
      1,
      0,
      0,
      NULL,
      1.919720,
      NULL,
      1,
      1,
      1.371621,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      0,
      1,
      1,
      0.642135,
      0.096023,
      1,
      1.250814,
      1,
      1,
      0.078801,
      NULL,
      0,
      6.774395,
      4,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      4,
      0.803591,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.452054,
      0,
      1,
      1,
      1.039227,
      1.834223,
      0.304988,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      2.656687,
      1,
      0,
      1.311155,
      17.509590,
      4,
      1.598643,
      1,
      1,
      0,
      0,
      0,
      0,
      1.615396,
      1.734231,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.426511,
      1,
      0.751677,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.615714,
      NULL,
      1,
      1.306984,
      0,
      NULL,
      0,
      1.142501,
      1.486856,
      1,
      1,
      1.437785,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0.975000,
      1.054776,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      '10340',
      '',
      NULL,
      1,
      '',
      '',
      '',
      0,
      '',
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


