set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7504246';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-2-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '4',
      NULL,
      NULL,
      '0212134',
      34.890876,
      3,
      2,
      NULL,
      '321431',
      NULL,
      '11- 4-1995',
      57.650519,
      NULL,
      0,
      NULL,
      NULL,
      1.301721,
      1.913847,
      1.929586,
      0,
      0,
      3,
      0.735213,
      0,
      1,
      3.122413,
      0.715029,
      0.698674,
      0,
      1.041514,
      1,
      NULL,
      1.011852,
      1,
      1.308812,
      0.744376,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.473288,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.035210,
      1,
      0.978934,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.021564,
      1.426404,
      1,
      1.444108,
      0.592298,
      1,
      NULL,
      0.896313,
      0.847879,
      1.027104,
      0.712789,
      NULL,
      0,
      0,
      1.563677,
      1,
      1.594825,
      NULL,
      0.785506,
      NULL,
      NULL,
      1.311651,
      0.208704,
      0.870915,
      1,
      0.003895,
      1.261294,
      0.515098,
      NULL,
      1.901536,
      0,
      1,
      NULL,
      1.985111,
      1.061105,
      NULL,
      0,
      1.770505,
      1,
      NULL,
      2,
      3.350307,
      1,
      NULL,
      0,
      1,
      3.873331,
      NULL,
      1,
      NULL,
      NULL,
      7.572290,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.603433,
      1,
      1,
      0,
      0,
      0,
      0.132899,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.711569,
      NULL,
      NULL,
      NULL,
      NULL,
      5.943450,
      1,
      2,
      0,
      1.809330,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.195895,
      0,
      1.618551,
      0.463025,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.167161,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.587929,
      0,
      1,
      NULL,
      0.581396,
      0,
      0.227848,
      NULL,
      1.992174,
      1.153428,
      0.413521,
      1,
      1,
      1.068729,
      NULL,
      NULL,
      0,
      NULL,
      1.735784,
      0.619630,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.557697,
      '04113',
      '',
      '',
      1.913028,
      '',
      '',
      NULL,
      0,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


