set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9317219';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-9-29 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '3',
      NULL,
      NULL,
      '4044412',
      6.895565,
      6,
      NULL,
      2,
      NULL,
      3.608356,
      ' 4-14-1974',
      13,
      NULL,
      0.529233,
      NULL,
      NULL,
      0.786396,
      1.687070,
      1,
      0.108486,
      NULL,
      1.496527,
      NULL,
      1.242936,
      1.923078,
      1.238841,
      0,
      NULL,
      0,
      1,
      0,
      NULL,
      0,
      0,
      1,
      0.217413,
      0,
      NULL,
      0,
      NULL,
      0.720079,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.051638,
      0,
      1.241763,
      1.032663,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.020252,
      0,
      1.517278,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.786889,
      0.059684,
      NULL,
      0,
      1.244880,
      0.856753,
      1.907915,
      0.609765,
      0,
      0,
      1,
      1.863362,
      1.949071,
      0,
      0,
      1.276581,
      0.339298,
      0.200800,
      NULL,
      1.598669,
      1.521317,
      NULL,
      0,
      0,
      NULL,
      0,
      1.982957,
      NULL,
      1,
      NULL,
      1,
      1,
      0,
      0.563564,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5.947427,
      0.896261,
      4,
      6.725243,
      0.809177,
      2.546029,
      5.543004,
      2.601283,
      0,
      NULL,
      NULL,
      NULL,
      1.670048,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.431432,
      0.267319,
      NULL,
      NULL,
      NULL,
      NULL,
      1.707458,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      6,
      1.012440,
      0.228997,
      NULL,
      1.642529,
      NULL,
      0,
      0.386797,
      2.479049,
      NULL,
      0,
      1.209141,
      NULL,
      NULL,
      NULL,
      3,
      3,
      NULL,
      1.443325,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      4.914430,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.569229,
      0,
      0,
      NULL,
      1.794020,
      0,
      NULL,
      NULL,
      NULL,
      1.665259,
      1,
      1,
      1,
      1,
      NULL,
      NULL,
      0.607501,
      NULL,
      1.827378,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.330968,
      '32312',
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


