set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9317219';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-3-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '113',
      '01',
      NULL,
      8.828980,
      NULL,
      43.111755,
      3,
      1,
      NULL,
      NULL,
      5,
      ' 2-26-1986',
      49,
      NULL,
      1,
      NULL,
      1,
      3.815979,
      1.195172,
      1.441826,
      1.826217,
      NULL,
      2,
      0.863531,
      NULL,
      0,
      1.422924,
      1.980186,
      0,
      1.794757,
      1.989106,
      1,
      3,
      NULL,
      1.067505,
      0,
      NULL,
      0.179311,
      4.233020,
      0,
      0.339135,
      1,
      NULL,
      1.727654,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.707563,
      0,
      3.128932,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.814466,
      5,
      1,
      1,
      NULL,
      1.323399,
      NULL,
      NULL,
      0.142153,
      NULL,
      NULL,
      NULL,
      0,
      1.788417,
      NULL,
      0,
      NULL,
      1.132783,
      0,
      NULL,
      0,
      NULL,
      1.815868,
      0,
      1,
      1,
      0,
      1,
      1.748341,
      NULL,
      NULL,
      0.511550,
      5.847778,
      1,
      0,
      1.541531,
      1.189769,
      1,
      0.325520,
      NULL,
      3,
      0.244124,
      2,
      1,
      NULL,
      0,
      0,
      2.739443,
      7.295566,
      9.618409,
      NULL,
      NULL,
      5.623415,
      5,
      6.885352,
      0.594835,
      1.201302,
      3.008712,
      NULL,
      0.900561,
      NULL,
      NULL,
      3,
      1.104524,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      5.337438,
      3.226156,
      0.296266,
      0.841218,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.861216,
      1,
      NULL,
      NULL,
      NULL,
      3.821457,
      1,
      4.819995,
      0,
      1.619412,
      NULL,
      0.654791,
      1,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.161477,
      2.524243,
      0.180833,
      0,
      2,
      2,
      NULL,
      0,
      1,
      2,
      1.760397,
      0.760205,
      NULL,
      NULL,
      0.166586,
      1.373247,
      1.959374,
      0.477930,
      NULL,
      1.562376,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      '43014',
      '',
      NULL,
      0,
      '',
      NULL,
      NULL,
      0.178248,
      NULL,
      '',
      '',
      2.237481,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


