set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9317219';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-2-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '141',
      '14',
      11,
      23.788052,
      '0403202',
      12.782458,
      NULL,
      0,
      NULL,
      NULL,
      5,
      ' 5-22-1986',
      40,
      10.659685,
      1,
      NULL,
      0.565174,
      2,
      1,
      0.181143,
      NULL,
      1,
      NULL,
      1.016203,
      NULL,
      1,
      2,
      1.433799,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.727750,
      1,
      1.302975,
      1.283000,
      3,
      1,
      3.395648,
      1,
      NULL,
      1.378168,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.104835,
      0,
      1.580153,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.769183,
      0.867422,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.507102,
      1,
      NULL,
      NULL,
      1.238056,
      0,
      NULL,
      1,
      0,
      1,
      0,
      NULL,
      0,
      1.075310,
      1.006515,
      0,
      1.367800,
      0,
      NULL,
      NULL,
      NULL,
      1.186096,
      0.031554,
      1,
      0,
      0,
      2,
      0,
      0.917625,
      0,
      1,
      0.998033,
      1.717177,
      0,
      0.617038,
      0,
      NULL,
      6,
      0.641599,
      NULL,
      7.905808,
      NULL,
      NULL,
      2,
      1.815967,
      NULL,
      0,
      1,
      0.844374,
      NULL,
      NULL,
      4.703342,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.861648,
      0,
      NULL,
      0,
      0.091709,
      0.217762,
      0.087739,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.817390,
      NULL,
      9.030463,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      5,
      6.422078,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      2,
      0.414892,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.272377,
      2,
      2,
      NULL,
      1.472701,
      1,
      1,
      0,
      1,
      3.167938,
      2.232311,
      NULL,
      1,
      1,
      1.120940,
      0.657219,
      1,
      1.816972,
      0.858461,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      '43323',
      NULL,
      '',
      1,
      NULL,
      '',
      NULL,
      2.417213,
      '2203',
      '',
      '',
      0.867550,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


