set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9317219';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-3-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '122',
      NULL,
      24.829385,
      19,
      '3221441',
      5.217470,
      0,
      0.404413,
      2,
      '230434',
      1.668888,
      '11- 0-1979',
      35.385787,
      7.424560,
      0.752134,
      NULL,
      0,
      1.676160,
      0.938325,
      0,
      0,
      0,
      0.020738,
      0,
      1.816566,
      NULL,
      3,
      NULL,
      0.638519,
      NULL,
      0,
      NULL,
      5,
      1,
      0.081083,
      1,
      NULL,
      0.304104,
      0,
      1,
      1,
      1,
      1.541103,
      0.841921,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.325509,
      1.928456,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.582246,
      1.565820,
      NULL,
      1.794186,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.039813,
      0.880318,
      0,
      1.912559,
      1.323318,
      1,
      NULL,
      0.831507,
      1,
      NULL,
      0,
      0.020658,
      NULL,
      0,
      1.336214,
      1,
      0,
      1,
      NULL,
      NULL,
      1,
      2.493517,
      1,
      NULL,
      2,
      0,
      3,
      NULL,
      4.359250,
      2,
      NULL,
      NULL,
      0.760150,
      0.730953,
      1,
      0,
      0.542876,
      3,
      5,
      5.933857,
      3.169514,
      5,
      2,
      NULL,
      6,
      NULL,
      1,
      1.167906,
      1.574344,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      0,
      0,
      0.742916,
      1.721109,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.672919,
      NULL,
      6.777201,
      2.261833,
      3.130472,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.268226,
      2.634392,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.202873,
      3,
      NULL,
      1,
      NULL,
      1.298188,
      NULL,
      NULL,
      NULL,
      1.771299,
      2.086928,
      1.509180,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.155978,
      1,
      NULL,
      1,
      1.343082,
      1,
      1.606598,
      3.792874,
      0.515166,
      0.568889,
      0.367986,
      0.088579,
      NULL,
      NULL,
      0,
      1.971034,
      NULL,
      NULL,
      0,
      0.561354,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.141068,
      '12414',
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      NULL,
      '0240',
      '',
      '',
      4.096793,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


