set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9317219';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-9-09 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '113',
      NULL,
      10,
      1,
      NULL,
      56,
      3,
      1.189091,
      0,
      '310423',
      1.001564,
      ' 1- 2-2000',
      42.503064,
      28,
      0,
      NULL,
      NULL,
      2,
      NULL,
      0.976930,
      0,
      0.536935,
      2.535322,
      1,
      1.993034,
      0.435059,
      3.436046,
      0,
      2.117690,
      1.479051,
      1,
      1.930941,
      1.981565,
      NULL,
      1,
      1,
      0,
      0,
      6.168591,
      1,
      5.746001,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0.634349,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      NULL,
      1.127472,
      NULL,
      1,
      NULL,
      0.979207,
      1,
      NULL,
      3,
      0,
      3,
      2,
      1,
      0.391636,
      1.727477,
      0,
      2.370046,
      4.304759,
      0,
      1,
      1,
      0.567327,
      NULL,
      NULL,
      0.398680,
      NULL,
      NULL,
      0.404005,
      1.716453,
      1.959096,
      0.811601,
      0,
      NULL,
      1,
      0,
      0.575610,
      1,
      1.747070,
      1.342224,
      0.083907,
      1.080245,
      0,
      1,
      0,
      0.233600,
      0,
      NULL,
      NULL,
      5.786760,
      0.535747,
      0,
      NULL,
      1,
      0,
      NULL,
      0,
      0,
      NULL,
      1,
      1,
      1,
      NULL,
      1,
      5.883119,
      3,
      7.893193,
      0.863789,
      6,
      NULL,
      0.777088,
      5,
      6,
      1,
      0.243696,
      0,
      0,
      NULL,
      1,
      3.894627,
      1.092125,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      0.056551,
      NULL,
      1.855553,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.973451,
      NULL,
      0.668540,
      3.967609,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.071065,
      2,
      6,
      NULL,
      5.121001,
      2,
      0,
      1.475017,
      NULL,
      NULL,
      NULL,
      11,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1,
      2.867637,
      1,
      NULL,
      0.835717,
      0.335168,
      1,
      1,
      1,
      0.592904,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      '01034',
      '',
      '',
      0.656612,
      '',
      '',
      '',
      3,
      '2320',
      '',
      '',
      0,
      1,
      3,
      0.748989,
      3,
      1.622067,
      3.610470,
      2,
      1);
commit;
end;
/


