set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9317219';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-9-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '112',
      '20000223',
      NULL,
      NULL,
      '0433113',
      57.981919,
      NULL,
      NULL,
      2,
      '200002',
      0,
      NULL,
      28,
      61,
      0.538800,
      NULL,
      1,
      2,
      1.314748,
      0.699432,
      1,
      1,
      NULL,
      NULL,
      0,
      0.570561,
      3.557540,
      NULL,
      1.293087,
      0,
      1,
      0,
      5.427074,
      0,
      0.881686,
      0,
      NULL,
      1.854695,
      0.577031,
      0,
      NULL,
      1.790240,
      NULL,
      1.005403,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.606800,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.518857,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.453142,
      0.584885,
      1.508538,
      0.965462,
      0.853519,
      0,
      1,
      1,
      0,
      0,
      NULL,
      0.800230,
      0,
      0.171924,
      0.431475,
      0.544618,
      1,
      0.647552,
      0.192057,
      NULL,
      0.649303,
      0,
      NULL,
      1.786847,
      0,
      1,
      0,
      0,
      NULL,
      1.024780,
      1.142869,
      1,
      1,
      3,
      5,
      NULL,
      5.097109,
      7,
      5.562340,
      1,
      NULL,
      7.802374,
      1.171221,
      NULL,
      1.966800,
      NULL,
      1.262675,
      1.664638,
      NULL,
      NULL,
      NULL,
      9.144994,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.224755,
      2,
      1,
      0,
      0,
      0.139661,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.096614,
      2,
      2,
      1.239639,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.070965,
      0.755247,
      3,
      2.474711,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0.065267,
      3.430766,
      0.535541,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.502601,
      2,
      2.670889,
      1.247707,
      1.452755,
      1,
      0,
      NULL,
      3,
      2,
      1,
      0,
      1.325282,
      0,
      1,
      1,
      NULL,
      NULL,
      1.724652,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.674212,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.827089,
      '23434',
      '',
      '',
      NULL,
      '',
      '',
      '',
      1.478533,
      '1102',
      '3342',
      '',
      1,
      NULL,
      3,
      0.765952,
      1.231114,
      NULL,
      0,
      0.691870,
      3);
commit;
end;
/


