set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9317219';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-9-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '330',
      '10314342',
      NULL,
      2,
      NULL,
      182,
      NULL,
      1.753413,
      2,
      '434203',
      4,
      ' 0- 1-1975',
      22,
      37,
      1.785753,
      NULL,
      1.245798,
      3,
      1.337691,
      NULL,
      0.453113,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      2.092172,
      1,
      NULL,
      1,
      4.234681,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0.268705,
      1,
      0,
      0.257010,
      1,
      0.086491,
      NULL,
      NULL,
      1.074236,
      NULL,
      NULL,
      0.074397,
      1,
      1.601644,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.956067,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.383376,
      0.514685,
      1.334583,
      0.493354,
      0,
      1,
      1,
      NULL,
      1.666841,
      0,
      0.594326,
      0.588986,
      NULL,
      1,
      NULL,
      1,
      1.877469,
      0,
      NULL,
      0,
      1.943740,
      NULL,
      0.532568,
      1.590172,
      1,
      0,
      NULL,
      1,
      5,
      NULL,
      1.201130,
      NULL,
      1,
      4,
      0,
      0.745874,
      5.920223,
      4.792140,
      NULL,
      3,
      4.979946,
      3.098213,
      5.313281,
      1,
      1.107375,
      0.822926,
      0.326664,
      3,
      1.311024,
      1.746419,
      4,
      0.975992,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.450325,
      NULL,
      2,
      NULL,
      1,
      1,
      NULL,
      1.420325,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      4.551538,
      0,
      2,
      0.420440,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.827339,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.691333,
      NULL,
      3,
      4,
      0,
      1,
      0,
      NULL,
      NULL,
      0,
      1.117394,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.736480,
      NULL,
      0.249435,
      0,
      1,
      NULL,
      0.614075,
      3,
      0.109491,
      NULL,
      0.456395,
      NULL,
      1.818929,
      1,
      1,
      0,
      1,
      0.337384,
      1.913027,
      0.647950,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      '41010',
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      '',
      0.156556,
      NULL,
      '4413',
      NULL,
      NULL,
      3.358422,
      2.724520,
      3.791346,
      NULL,
      2,
      3.620341,
      0,
      2);
commit;
end;
/


