set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9317219';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-3-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '113',
      '14424034',
      65,
      16,
      '1220001',
      191,
      6,
      3.666313,
      3,
      '314021',
      1.865710,
      ' 6-14-2001',
      NULL,
      22,
      1.275587,
      NULL,
      1,
      1,
      1.677421,
      0.183750,
      1,
      0.670794,
      2.689471,
      0,
      1.876096,
      1,
      NULL,
      0.089159,
      0.289442,
      0,
      1,
      0.488257,
      2,
      NULL,
      4.758104,
      NULL,
      0.360957,
      0,
      3.275459,
      1,
      1.154808,
      NULL,
      2.554976,
      0.171741,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.426824,
      1.329008,
      1,
      0,
      1.076726,
      0.196833,
      0,
      1.036303,
      0,
      1,
      1,
      NULL,
      0,
      1,
      0,
      NULL,
      0.168979,
      1,
      0,
      1.020986,
      0.952400,
      5,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0.873196,
      NULL,
      NULL,
      1.485929,
      1,
      NULL,
      1.689197,
      NULL,
      1.077562,
      1.646115,
      1.687012,
      NULL,
      NULL,
      0,
      0.238375,
      NULL,
      1,
      0.032004,
      0,
      0,
      0,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      5.878363,
      2.744799,
      NULL,
      NULL,
      1.241289,
      3.305480,
      1.024570,
      1.186165,
      NULL,
      4.023972,
      1,
      0,
      NULL,
      0.800687,
      2.655919,
      NULL,
      5.544203,
      0,
      1.074482,
      0.660260,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.737517,
      1,
      0,
      NULL,
      0,
      0.608072,
      0.980807,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.566568,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      3,
      1.555949,
      1.936765,
      0,
      1.034895,
      NULL,
      NULL,
      NULL,
      0.584958,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.967617,
      1,
      NULL,
      NULL,
      0.396391,
      1,
      NULL,
      1.070626,
      NULL,
      NULL,
      1,
      0.235407,
      0,
      0,
      NULL,
      1.902569,
      0.818050,
      0.658299,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.265882,
      '40012',
      '',
      NULL,
      0,
      '',
      '',
      '',
      1.871101,
      '0420',
      NULL,
      '',
      1.237586,
      5,
      2,
      2,
      3.529768,
      3,
      3,
      1.830784,
      2);
commit;
end;
/


