set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9317219';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-4-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      82,
      NULL,
      '4123313',
      137.136558,
      0,
      2.489492,
      1,
      '101213',
      3.469263,
      ' 5-27-1997',
      12.362364,
      18,
      1.520388,
      NULL,
      NULL,
      0.824837,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      0.926552,
      0.526631,
      3,
      0,
      1.262499,
      1,
      1.021066,
      1.409479,
      0,
      1.274353,
      1,
      1,
      0,
      1,
      1.925299,
      NULL,
      0,
      1.428886,
      0,
      0,
      NULL,
      NULL,
      1.221702,
      NULL,
      NULL,
      2.031302,
      1,
      1.510035,
      1.353259,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.925244,
      0.622399,
      1,
      2,
      1,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.345107,
      2.811576,
      NULL,
      5.260711,
      NULL,
      0.459975,
      1.225463,
      1,
      0.891004,
      1,
      NULL,
      0.872379,
      1.448398,
      1.918878,
      NULL,
      NULL,
      NULL,
      0.148048,
      NULL,
      0.066447,
      1.226271,
      1.598410,
      0.137918,
      1.066783,
      0,
      1,
      0,
      0.605279,
      3.326746,
      2.851711,
      1,
      0,
      NULL,
      NULL,
      1.661355,
      1,
      3,
      2,
      3,
      7.476315,
      0.165445,
      2.312705,
      4,
      4,
      0,
      1.237157,
      0.945567,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      1,
      1.204321,
      0,
      0.031439,
      0.049795,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      0,
      0,
      3.452936,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.536845,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0.766976,
      NULL,
      6,
      3,
      0,
      2,
      1,
      NULL,
      NULL,
      NULL,
      1.498278,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.185843,
      0.347491,
      0.400750,
      NULL,
      1,
      NULL,
      0.967210,
      1,
      NULL,
      NULL,
      0.356336,
      1,
      0.853396,
      0,
      0,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.625698,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      '',
      '',
      0.223444,
      '',
      NULL,
      '',
      6.138791,
      '1440',
      '3043',
      '1432',
      1.654806,
      3,
      2,
      3.986430,
      NULL,
      1.456645,
      2.641863,
      4,
      0.512158);
commit;
end;
/


