set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7716130';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-11-29 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '214',
      '14002203',
      NULL,
      35.196870,
      '4041040',
      36,
      1,
      0.961814,
      2,
      '243421',
      2,
      NULL,
      39,
      2.182984,
      1.101367,
      NULL,
      0,
      0,
      0,
      0.335241,
      NULL,
      NULL,
      0.512611,
      0.113129,
      NULL,
      0.439507,
      4,
      0,
      0.737778,
      NULL,
      1,
      1.291358,
      1,
      0,
      0.936855,
      NULL,
      1.877136,
      NULL,
      2.138887,
      0,
      4,
      1.386264,
      0,
      0.177547,
      NULL,
      NULL,
      1.287224,
      NULL,
      NULL,
      2.977382,
      0.098501,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.902895,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4.411391,
      6.069622,
      1,
      1.728976,
      1,
      2.458370,
      0.425624,
      1.830145,
      0.282866,
      0.016780,
      1.252528,
      5,
      2.619053,
      0,
      0.313436,
      0,
      1,
      0.646808,
      NULL,
      NULL,
      2.953331,
      NULL,
      1,
      0.237528,
      0,
      0.385068,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      2.285656,
      4,
      2,
      NULL,
      1.086834,
      5.965450,
      7,
      4.870476,
      2,
      6.267025,
      5.263475,
      3.992165,
      2,
      3,
      1.144888,
      1.742840,
      0.251247,
      5,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.399903,
      1,
      1,
      0.443882,
      0.017589,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2.034390,
      NULL,
      1,
      0,
      0,
      2.442044,
      9,
      NULL,
      0.558004,
      NULL,
      NULL,
      NULL,
      1.606916,
      5.501194,
      NULL,
      1,
      NULL,
      1,
      0.094468,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1.544984,
      1.749851,
      NULL,
      2,
      1,
      NULL,
      0.059723,
      1,
      0,
      1.271697,
      1,
      0,
      0,
      1,
      NULL,
      0.010539,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.147011,
      '32231',
      '04413',
      '',
      0,
      NULL,
      '',
      NULL,
      1,
      NULL,
      '',
      '',
      0,
      4,
      0,
      NULL,
      2.489341,
      1,
      0.400973,
      6,
      0.002411);
commit;
end;
/


