set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7716130';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-5-29 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '33022224',
      56.692714,
      74.749752,
      '4430304',
      34,
      NULL,
      3.509996,
      NULL,
      '330001',
      2.321809,
      ' 8-22-1974',
      16.499364,
      242,
      0,
      NULL,
      0.493970,
      0.285194,
      NULL,
      0.087570,
      NULL,
      NULL,
      1.922607,
      NULL,
      0,
      NULL,
      3,
      NULL,
      0.923971,
      NULL,
      NULL,
      0.999423,
      5.785925,
      0.492482,
      0.308542,
      1.211573,
      1,
      1.056754,
      7,
      0,
      0,
      0.446262,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0.180305,
      1,
      0.171114,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.065295,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.910416,
      7.105710,
      4.066187,
      0.859523,
      0,
      1.711969,
      0,
      0,
      1.425799,
      1,
      0,
      1,
      0.739170,
      2,
      1.447399,
      1.784347,
      0.254847,
      0.594408,
      0,
      NULL,
      1,
      1.432175,
      0.025480,
      NULL,
      NULL,
      1,
      2.411036,
      NULL,
      1.583765,
      0,
      NULL,
      1.503626,
      NULL,
      NULL,
      2.259040,
      5.236178,
      NULL,
      6.117289,
      NULL,
      3.489139,
      4,
      1,
      NULL,
      7.484445,
      5.135760,
      NULL,
      2.656242,
      1,
      3,
      1.441651,
      0.183527,
      8.545089,
      0.040012,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.657517,
      1,
      NULL,
      0.265085,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3.134113,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3.083886,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.593418,
      1.148629,
      0.267240,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      2,
      0.245409,
      0.961392,
      NULL,
      0.800589,
      2,
      2,
      1.722422,
      1.702309,
      0,
      0.950689,
      1.661289,
      1,
      1.775494,
      1,
      1.539419,
      0.471588,
      1.073442,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.809818,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      '31032',
      '02010',
      '',
      1.493888,
      '',
      '',
      '',
      1.961218,
      '',
      '',
      '',
      3.050003,
      NULL,
      0.767930,
      2.294886,
      NULL,
      1,
      3.370545,
      4.247131,
      NULL);
commit;
end;
/


