set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7716130';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-5-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '02133213',
      NULL,
      66,
      '0130321',
      25.689784,
      6,
      1.652406,
      0,
      '112341',
      2,
      NULL,
      27,
      14,
      NULL,
      NULL,
      2,
      0,
      1,
      1,
      1.905321,
      NULL,
      NULL,
      0.412745,
      NULL,
      1.054086,
      5,
      1.236306,
      1,
      0,
      2,
      NULL,
      4,
      0.106454,
      0.490161,
      0.799046,
      1,
      1.735302,
      6,
      NULL,
      0.659780,
      0.030677,
      1.919000,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.358953,
      0,
      0.665335,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.820620,
      0.115348,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.155657,
      2,
      3.613888,
      0.362073,
      4,
      NULL,
      0,
      0,
      1.468605,
      5.465985,
      0.776813,
      NULL,
      0,
      5,
      0,
      1.680018,
      NULL,
      1,
      0,
      NULL,
      1.415125,
      NULL,
      0.148273,
      0.700524,
      2,
      1.727767,
      0.256297,
      0.812389,
      NULL,
      4,
      0.006447,
      0.163948,
      1.108791,
      0,
      2,
      2.481439,
      6,
      10,
      6.092553,
      5.129867,
      9,
      NULL,
      8.455107,
      3,
      3.251894,
      4,
      NULL,
      1.181787,
      1,
      NULL,
      1,
      1.520821,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      1,
      1.988812,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.313258,
      NULL,
      NULL,
      NULL,
      NULL,
      0.590939,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.362776,
      3.583030,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      8.945555,
      1,
      0,
      0,
      1.935327,
      NULL,
      NULL,
      NULL,
      0.569474,
      1,
      0.781081,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      2.641948,
      1,
      1.491499,
      3,
      2,
      NULL,
      1.266990,
      1.743585,
      1.890562,
      0,
      1.314783,
      0.555853,
      NULL,
      0,
      0.671269,
      1,
      0.304475,
      0.157215,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.246002,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.747861,
      '41234',
      '22330',
      '',
      0,
      '',
      NULL,
      NULL,
      0.627037,
      NULL,
      NULL,
      '',
      NULL,
      0,
      0.264043,
      2,
      3.309382,
      0.476645,
      3.702831,
      3.413962,
      1);
commit;
end;
/


