set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7716130';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-6-07 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2140',
      '14212210',
      87,
      NULL,
      '4240111',
      37.001223,
      0,
      2.055210,
      3,
      '110044',
      1,
      '11-22-1986',
      10,
      5,
      1.443266,
      NULL,
      NULL,
      0,
      1.444067,
      0,
      0,
      2,
      0.911288,
      1,
      1,
      1,
      8,
      0.767152,
      3,
      0.237868,
      NULL,
      1.449216,
      8,
      1.324372,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.932797,
      2,
      1.490128,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.147305,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.300813,
      1.356076,
      2.857451,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.329934,
      5.710268,
      NULL,
      2,
      NULL,
      7,
      0,
      1.202341,
      0.754088,
      1.720162,
      0,
      1.890618,
      7.430780,
      1.253968,
      NULL,
      0,
      0.538478,
      1,
      NULL,
      NULL,
      7,
      4.734650,
      2.853775,
      NULL,
      4,
      1,
      0,
      5.847628,
      1,
      1.715495,
      NULL,
      7.002145,
      5.719667,
      7.747808,
      2.126624,
      4,
      5,
      6,
      7,
      3,
      9,
      4,
      6,
      1,
      7,
      NULL,
      1.089589,
      2,
      0.565624,
      1.014670,
      2.274298,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.530887,
      NULL,
      2,
      0,
      1.498925,
      0,
      0.858631,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      2.607294,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      3.602484,
      1.619865,
      NULL,
      NULL,
      NULL,
      7.346038,
      2,
      NULL,
      6.317501,
      0.934576,
      2,
      3,
      NULL,
      NULL,
      NULL,
      1.929557,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.899028,
      1.793517,
      0.603594,
      NULL,
      0,
      2.938801,
      3.559255,
      1.036904,
      3.955313,
      NULL,
      NULL,
      0.494543,
      1,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      5,
      '01212',
      '04313',
      '',
      1,
      '',
      '',
      '',
      1.957746,
      NULL,
      NULL,
      '',
      NULL,
      NULL,
      1.777560,
      3.647305,
      1.012474,
      3,
      1,
      1.637294,
      3);
commit;
end;
/


