set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8812417';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-5-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1034',
      NULL,
      NULL,
      22.423068,
      '4144142',
      NULL,
      NULL,
      3,
      0,
      '101100',
      1.246049,
      ' 6- 2-1994',
      4.359573,
      24,
      NULL,
      NULL,
      0,
      2,
      NULL,
      NULL,
      NULL,
      0.940724,
      0.945121,
      0.043889,
      NULL,
      1.457034,
      5.591251,
      0,
      0.454980,
      3,
      0,
      3.471208,
      3.858015,
      0,
      0.066492,
      6.256434,
      3.325940,
      1,
      0,
      0,
      5.902872,
      NULL,
      0.449202,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      4.289326,
      0.671719,
      NULL,
      NULL,
      1.259040,
      0.992920,
      0.004441,
      NULL,
      1.508435,
      2,
      NULL,
      NULL,
      1.919576,
      2.987117,
      1,
      1.392249,
      2.126616,
      0.967745,
      0.415134,
      1,
      1.642333,
      0,
      0.236717,
      0,
      2,
      0,
      0.294047,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      4.840403,
      3.222806,
      3.831551,
      3.270719,
      NULL,
      0,
      0,
      0.385114,
      2,
      1,
      0,
      0.606082,
      0,
      1,
      0.006866,
      0.500119,
      1.338219,
      NULL,
      1.386830,
      NULL,
      1.886522,
      0.306559,
      1,
      1.168111,
      0,
      0.785814,
      0.865404,
      0,
      0.782104,
      0.027154,
      1,
      0,
      0.935878,
      1.256375,
      0.046462,
      6,
      6,
      0.627087,
      7,
      5.635589,
      1,
      0.847078,
      NULL,
      5,
      2.644672,
      NULL,
      2,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      0.836476,
      3.132252,
      1.046677,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.347109,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.857128,
      0,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.042413,
      1.212247,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.222790,
      NULL,
      0.844366,
      2,
      3,
      0,
      NULL,
      1.910742,
      1,
      2.453285,
      1,
      0,
      0,
      NULL,
      0,
      1.481034,
      1.789839,
      1,
      1.923640,
      0.282222,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.375181,
      1.687421,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.804708,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.289270,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.919068,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.454134,
      NULL,
      NULL,
      NULL,
      NULL,
      1.786323,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      3.616470,
      0.936325,
      3,
      NULL,
      1,
      1,
      5.768387,
      '02132',
      NULL,
      NULL,
      1,
      '',
      '',
      NULL,
      1,
      NULL,
      '',
      '',
      0,
      2,
      2,
      4.240970,
      NULL,
      5,
      3.420424,
      1,
      0);
commit;
end;
/


