set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8812417';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-11-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1242',
      '41104112',
      36.151170,
      10.378170,
      '3414104',
      8,
      6,
      NULL,
      1,
      '340110',
      NULL,
      ' 1-27-1991',
      4.427824,
      NULL,
      1.363547,
      NULL,
      0.026699,
      NULL,
      0.554828,
      1.374310,
      0.320747,
      0.087256,
      0,
      NULL,
      NULL,
      0.450291,
      6,
      6,
      0,
      9,
      NULL,
      NULL,
      4.277731,
      0,
      3,
      1.763477,
      0,
      0,
      0.869648,
      1,
      4.003185,
      5,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.301548,
      0.032220,
      1.849477,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      NULL,
      3.901761,
      NULL,
      NULL,
      2.159269,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.165778,
      2.922332,
      NULL,
      0.811900,
      3.519441,
      NULL,
      NULL,
      1.526911,
      NULL,
      5.941600,
      5.864366,
      0,
      NULL,
      5,
      0.640200,
      0.248003,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0.275186,
      0.492935,
      1,
      NULL,
      0.547063,
      0,
      1,
      1.490004,
      NULL,
      NULL,
      NULL,
      1.331120,
      2.983860,
      7.784346,
      1.313925,
      1,
      NULL,
      5,
      5,
      2,
      1.138868,
      5.929419,
      1,
      0.446169,
      0.037629,
      0.539123,
      NULL,
      0.127492,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      1,
      0.030022,
      1.515978,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.140000,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.703968,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.353909,
      0.830177,
      4.720345,
      NULL,
      0.288233,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.597195,
      1.782839,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.348677,
      0,
      2,
      0,
      3.598812,
      NULL,
      NULL,
      NULL,
      0,
      1.865577,
      0.275322,
      NULL,
      0,
      NULL,
      1.843871,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4,
      '30240',
      NULL,
      '',
      0,
      '',
      '',
      '',
      1,
      NULL,
      NULL,
      NULL,
      4.070597,
      2,
      NULL,
      3.556511,
      1.888192,
      5.227559,
      NULL,
      0.357361,
      2);
commit;
end;
/


