set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8812417';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-7-19 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2204',
      '02143414',
      70.014548,
      91.646423,
      '1240040',
      31,
      5,
      0,
      0,
      NULL,
      1,
      ' 8- 7-1991',
      134,
      11,
      NULL,
      NULL,
      NULL,
      3.820396,
      1,
      0,
      0,
      0,
      1,
      0,
      NULL,
      0,
      9,
      0,
      NULL,
      0.405051,
      4,
      3.022593,
      5,
      0,
      NULL,
      NULL,
      6.852748,
      0.097269,
      1,
      NULL,
      3.373048,
      3.197665,
      5.602705,
      1.228062,
      NULL,
      NULL,
      1.239429,
      NULL,
      NULL,
      2.527352,
      7.249911,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      3.986305,
      10,
      6,
      1,
      1,
      5,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.871150,
      2,
      NULL,
      0.705872,
      1.965087,
      3,
      0.397011,
      1,
      0.088055,
      0,
      0.007340,
      NULL,
      1,
      1.113493,
      0.356856,
      1,
      1.685086,
      0.513439,
      0.803528,
      NULL,
      0,
      1.266000,
      0.227864,
      1.686345,
      NULL,
      0,
      3.073128,
      1,
      1.358293,
      1,
      1.924078,
      0.312726,
      1,
      0.930593,
      0.818848,
      1.949297,
      0.630690,
      0,
      2,
      8.155059,
      6,
      2,
      0,
      2,
      NULL,
      4.535566,
      4,
      5,
      3.483981,
      NULL,
      0,
      1.274972,
      0.646014,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.609731,
      0,
      1,
      2,
      0,
      1.062232,
      1,
      1.333449,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.529207,
      2,
      0.969113,
      NULL,
      NULL,
      NULL,
      4,
      1.564382,
      0.069336,
      2.158074,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1.929681,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      NULL,
      NULL,
      1,
      2.225261,
      0,
      1.329093,
      3,
      2,
      1.778277,
      1.121295,
      NULL,
      NULL,
      0.509441,
      0,
      0.695281,
      0.321493,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.681894,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.995592,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.471448,
      NULL,
      1,
      1,
      1.176873,
      2,
      5.452079,
      '34202',
      '40330',
      '',
      3.108766,
      '02242',
      '',
      '',
      1,
      '',
      '',
      '',
      0.402584,
      NULL,
      2,
      3.633983,
      NULL,
      2,
      1.868168,
      NULL,
      2);
commit;
end;
/


