set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9817670';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-10-29 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '234',
      '23342422',
      NULL,
      21,
      NULL,
      NULL,
      4,
      0,
      1,
      '110423',
      4.919484,
      ' 3- 5-1984',
      0.472338,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.438227,
      1.898153,
      1.795626,
      2.746718,
      1.408787,
      0,
      1.451753,
      0,
      4,
      NULL,
      1,
      1.329334,
      NULL,
      0.793182,
      NULL,
      NULL,
      NULL,
      0,
      0.846017,
      0,
      0.546894,
      0,
      0.291564,
      1.715876,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.392437,
      NULL,
      0.339124,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4,
      3,
      1,
      2,
      1,
      0,
      1,
      0.893518,
      1.318831,
      NULL,
      0,
      0.760190,
      0.556717,
      0,
      0.757792,
      NULL,
      1.482047,
      NULL,
      NULL,
      NULL,
      2,
      0.499650,
      1.176236,
      NULL,
      0.917748,
      2.944944,
      0.501868,
      1,
      0,
      0.877403,
      NULL,
      1,
      1.705081,
      1.318242,
      0,
      1.501341,
      3,
      2,
      3.420884,
      6.193933,
      7,
      0,
      1.585702,
      NULL,
      2,
      1,
      NULL,
      3.220579,
      0,
      0,
      7.501402,
      1.168674,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.738709,
      0,
      0,
      1,
      1.927295,
      1,
      0,
      1.954817,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.032513,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.378385,
      0.010522,
      0.491630,
      0,
      2,
      7,
      3.341270,
      1.467478,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.981809,
      NULL,
      2.731940,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.108570,
      0,
      2.425143,
      2.843467,
      NULL,
      1,
      NULL,
      3.573666,
      0,
      NULL,
      1.211932,
      1,
      1,
      NULL,
      1,
      1.344555,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.052637,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      '00322',
      '',
      '',
      0,
      '',
      NULL,
      '',
      1.282130,
      '3242',
      '',
      '',
      NULL,
      1.488552,
      3,
      NULL,
      1,
      NULL,
      3,
      0.137360,
      NULL);
commit;
end;
/


