set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9817670';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-11-04 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '02110421',
      NULL,
      60,
      NULL,
      33,
      NULL,
      0,
      0,
      NULL,
      1,
      '11-20-1980',
      40,
      26,
      1.892592,
      NULL,
      0,
      2.886930,
      1,
      1,
      0.705209,
      0.648686,
      0,
      0,
      NULL,
      1.066064,
      0,
      0,
      1,
      0.167003,
      1,
      1,
      1,
      0,
      0,
      0,
      1,
      1,
      2.548026,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.849796,
      1.419990,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.674627,
      1.365950,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.973234,
      0.387966,
      1.332238,
      1.478446,
      0.357448,
      1.353671,
      0,
      0.992147,
      1.069751,
      0,
      1,
      1,
      1,
      0,
      0.818561,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1.575483,
      NULL,
      0,
      1.022494,
      NULL,
      1.485720,
      NULL,
      1,
      NULL,
      NULL,
      0.719882,
      NULL,
      0,
      1,
      1,
      NULL,
      0.011894,
      3,
      2.695563,
      NULL,
      1,
      1,
      0,
      0.712007,
      NULL,
      1,
      0.595862,
      NULL,
      NULL,
      NULL,
      8.439675,
      0.659456,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.129903,
      NULL,
      1,
      0,
      1,
      NULL,
      1.377783,
      0.549471,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      4.063331,
      NULL,
      1.545361,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.909973,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      3,
      NULL,
      1,
      3.306722,
      1,
      NULL,
      NULL,
      NULL,
      1.153760,
      1.417210,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.480177,
      1.352493,
      0,
      0.450401,
      2.096767,
      0.843683,
      1,
      1.960804,
      1,
      NULL,
      1.898228,
      1,
      0.011077,
      0,
      0.805470,
      1.832935,
      1.723988,
      0.094776,
      1.444528,
      1.935699,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      '',
      '',
      1,
      '',
      '',
      '',
      0.000007,
      '3402',
      '',
      '',
      NULL,
      1,
      2.089458,
      4.437989,
      NULL,
      NULL,
      1,
      NULL,
      3);
commit;
end;
/


