set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9781838';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-12-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '23214130',
      48.587466,
      18.078277,
      '2234343',
      NULL,
      5,
      0.438279,
      1,
      NULL,
      5.606438,
      ' 1-22-1984',
      124,
      29.581252,
      1,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      2.686343,
      3.392820,
      NULL,
      0.109421,
      0,
      NULL,
      0,
      NULL,
      1.557752,
      0.056968,
      3,
      0,
      0.500365,
      1.892477,
      1.341935,
      0.048164,
      1,
      2.380273,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.036684,
      0,
      0.856364,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      1.257900,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0,
      1.753993,
      0,
      0,
      0,
      0.095441,
      NULL,
      NULL,
      1,
      1.993498,
      1.338475,
      0,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      1.708391,
      NULL,
      0.262283,
      0.920422,
      0.541497,
      NULL,
      1.139166,
      2.613373,
      1,
      0,
      NULL,
      1.793734,
      1.852377,
      1.215123,
      NULL,
      NULL,
      1.844077,
      0.470892,
      2,
      NULL,
      0.107459,
      0.277355,
      0,
      1.962765,
      1,
      0,
      NULL,
      0,
      NULL,
      NULL,
      8.755744,
      0.005179,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0,
      0.679705,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.008044,
      NULL,
      NULL,
      NULL,
      NULL,
      0.175073,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.499421,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.441265,
      3,
      NULL,
      2.744035,
      3.785811,
      2,
      1.045972,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.446526,
      0.982539,
      0,
      0,
      1,
      NULL,
      0,
      0.444281,
      NULL,
      0.203408,
      0,
      1,
      0.757409,
      1,
      NULL,
      1.029916,
      1,
      1.425925,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.846002,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.728094,
      '32013',
      '',
      '',
      1.415399,
      '',
      '',
      NULL,
      1.224479,
      '',
      '',
      '',
      NULL,
      1.054442,
      1.052228,
      1.962094,
      3.526019,
      NULL,
      1,
      NULL,
      0.135286);
commit;
end;
/


