set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8703287';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-3-31 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      2.555199,
      0,
      '033232',
      0,
      ' 4-12-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      1.974126,
      1,
      3,
      1.927232,
      1.440179,
      2.609064,
      1.230781,
      0.389132,
      2,
      0,
      5,
      0.941129,
      0,
      2.330045,
      2,
      NULL,
      4.127494,
      NULL,
      1.599046,
      2.558204,
      0,
      NULL,
      1,
      3,
      5.836541,
      NULL,
      0.354760,
      1.646948,
      NULL,
      NULL,
      1.055760,
      NULL,
      NULL,
      NULL,
      0.649964,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      2,
      NULL,
      2,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0.354799,
      NULL,
      NULL,
      1,
      2.886824,
      6,
      0,
      NULL,
      1,
      4,
      0.336142,
      0,
      1.766168,
      NULL,
      2,
      0.588862,
      7,
      0,
      1,
      0.162538,
      1.102120,
      0,
      NULL,
      0.084762,
      1.886905,
      0.487839,
      0.045224,
      1.822446,
      1.083894,
      NULL,
      0,
      NULL,
      NULL,
      5,
      2.697889,
      6,
      NULL,
      6.523130,
      NULL,
      6.458581,
      5.746918,
      NULL,
      2,
      4.090326,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      3,
      0,
      2,
      3.356365,
      3,
      1,
      0.420195,
      NULL,
      NULL,
      2.489513,
      2,
      1.418128,
      3.868413,
      1,
      2,
      0,
      2.173222,
      4.881644,
      2.132807,
      0.623436,
      1.291945,
      0,
      1.635665,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      5.774781,
      NULL,
      4,
      0,
      1.238227,
      NULL,
      NULL,
      NULL,
      NULL,
      1.896774,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2.361650,
      1,
      3,
      0,
      0,
      0.026710,
      0.343713,
      1,
      0,
      0.656763,
      1.947524,
      1.924096,
      1,
      NULL,
      1.727795,
      0,
      0,
      0.632979,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '24124',
      '42302',
      NULL,
      NULL,
      '',
      '',
      '',
      1.100449,
      '3314',
      '1434',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


