set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8703287';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-2-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '0',
      NULL,
      NULL,
      '0034242',
      38,
      3,
      NULL,
      3,
      '222312',
      3.840112,
      '11- 3-1981',
      18,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1.742643,
      0.334162,
      1.312896,
      1,
      NULL,
      1.588652,
      3.395278,
      1,
      1.763273,
      NULL,
      1,
      1,
      1,
      0,
      0,
      NULL,
      0,
      1,
      1.315733,
      0.193299,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.155154,
      1,
      1.845585,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      0.241507,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.544790,
      0.108267,
      3.967309,
      1.921644,
      4.402094,
      0,
      3.943881,
      1.261313,
      1.463768,
      0,
      4.981425,
      1.446602,
      1.257519,
      2.329083,
      1,
      1.004051,
      1.867115,
      0,
      0,
      NULL,
      1,
      1,
      1,
      0,
      0.962916,
      1.130035,
      1.374556,
      0.247547,
      1,
      0,
      1,
      0.615428,
      0.905041,
      0.175354,
      2,
      1.899433,
      2.493985,
      0.970907,
      2.336595,
      NULL,
      NULL,
      3,
      2.309009,
      2.785727,
      3,
      2,
      0.417382,
      3,
      1.779030,
      NULL,
      NULL,
      4.229698,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.287314,
      0.906721,
      0,
      1,
      1,
      0,
      0.523598,
      0.980151,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.272027,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.050154,
      0.483526,
      4,
      5,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1.318079,
      0.765492,
      0,
      0,
      0.490236,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.721128,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.746521,
      0,
      NULL,
      NULL,
      0.323828,
      NULL,
      0.698931,
      0,
      0,
      1.215156,
      NULL,
      NULL,
      1.313101,
      1,
      0.147251,
      0,
      1,
      1,
      1.887211,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      5.676771,
      '03414',
      '14332',
      '',
      1.251254,
      '',
      '',
      '',
      NULL,
      '3210',
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


