set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8703287';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-5-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '041',
      NULL,
      25.852642,
      NULL,
      '0422010',
      67,
      NULL,
      2.983692,
      0,
      NULL,
      4.005457,
      NULL,
      NULL,
      NULL,
      0.544866,
      NULL,
      1.698256,
      0,
      NULL,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0.307721,
      1.892726,
      NULL,
      0.518190,
      1.265571,
      1.410039,
      1,
      1,
      1.877539,
      0,
      1.518425,
      1,
      1.226782,
      1.383561,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.544711,
      1.577336,
      0.361490,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.789038,
      1.724713,
      0.145287,
      1.530431,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.943327,
      1.568600,
      NULL,
      0.550532,
      0,
      0,
      1,
      0,
      0,
      0.780935,
      0,
      0,
      0.109355,
      0.725160,
      0,
      1.882866,
      0.540426,
      NULL,
      0.198723,
      NULL,
      NULL,
      1.774682,
      NULL,
      NULL,
      NULL,
      0,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1.342291,
      0.771803,
      0.479737,
      0,
      1,
      NULL,
      2.512076,
      1,
      3,
      0,
      NULL,
      0,
      5.287876,
      1.521623,
      2,
      0,
      1,
      NULL,
      NULL,
      0.975508,
      1.498546,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.595532,
      0,
      0,
      0,
      NULL,
      NULL,
      0.136752,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.443716,
      NULL,
      NULL,
      NULL,
      NULL,
      0.347173,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      0.562837,
      NULL,
      NULL,
      NULL,
      0.337485,
      1,
      NULL,
      3.069381,
      1.366307,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0.070494,
      0,
      1.266199,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.331777,
      0,
      0,
      0,
      3.809864,
      1,
      1.783342,
      1,
      NULL,
      0,
      1.002739,
      NULL,
      0.342096,
      1,
      1,
      0.134419,
      1.400930,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.537014,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.496938,
      '31023',
      '02144',
      NULL,
      0,
      NULL,
      '',
      '',
      3,
      '0330',
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


