set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8703287';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-2-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '441',
      NULL,
      53.686281,
      11.619205,
      '0124300',
      57.462938,
      2,
      NULL,
      2,
      '431121',
      6.037449,
      ' 7-23-1996',
      NULL,
      18,
      0.247378,
      NULL,
      1.410805,
      NULL,
      3,
      0,
      0.133557,
      1.797843,
      NULL,
      1,
      1,
      NULL,
      0,
      1.247409,
      1,
      1.089508,
      0,
      0,
      5.036276,
      1,
      1,
      1,
      0.783009,
      0,
      0.782268,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.271431,
      1.950265,
      0.774681,
      0.607683,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.586950,
      1,
      1.900050,
      0.650106,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.276717,
      NULL,
      NULL,
      0,
      3,
      NULL,
      NULL,
      NULL,
      0,
      0.429247,
      3,
      0.371681,
      0,
      4.483821,
      NULL,
      0.097628,
      NULL,
      1.099358,
      1,
      NULL,
      1.742281,
      1.304009,
      1,
      NULL,
      1,
      1.233907,
      0.245128,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.471037,
      NULL,
      0,
      0.855018,
      5.962101,
      1,
      NULL,
      4.488422,
      0.162660,
      0,
      0,
      NULL,
      NULL,
      1.984233,
      1.138778,
      NULL,
      1,
      NULL,
      NULL,
      3,
      0.367086,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.180814,
      0,
      1,
      1,
      0.170368,
      1.414919,
      1.632875,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.613065,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.668304,
      3,
      0.512010,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.319867,
      0.259063,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0.597447,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.955568,
      NULL,
      2.309101,
      1,
      1.418592,
      1,
      NULL,
      1,
      0.597647,
      NULL,
      1.499195,
      0.097695,
      NULL,
      1.176899,
      0,
      1,
      0,
      0.655158,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.666332,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.070613,
      '10131',
      '20440',
      '',
      0.560854,
      '',
      '',
      '',
      2,
      '1301',
      NULL,
      '',
      3.630001,
      3,
      3,
      3.620185,
      0.586358,
      2.873340,
      0,
      3,
      3.128364);
commit;
end;
/


