set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8703287';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-8-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '432',
      '44232421',
      5,
      NULL,
      NULL,
      NULL,
      6,
      3,
      1,
      '221312',
      3.278885,
      ' 9- 1-1989',
      NULL,
      44.829443,
      1.060042,
      NULL,
      0.392418,
      1,
      0,
      0.742975,
      0.201840,
      0,
      0,
      1,
      2,
      0,
      1,
      0.921906,
      0,
      NULL,
      1,
      1.257413,
      0,
      NULL,
      0,
      0.970499,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1.987469,
      0.813879,
      1,
      NULL,
      NULL,
      0.966507,
      NULL,
      NULL,
      1,
      0.286114,
      0.619843,
      0.370003,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.289765,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.824134,
      1,
      NULL,
      NULL,
      1.252800,
      0,
      0.976106,
      NULL,
      0,
      0,
      NULL,
      0,
      1.031859,
      0,
      0.187256,
      NULL,
      1.868739,
      1,
      1,
      NULL,
      0,
      0,
      0,
      NULL,
      1,
      0,
      NULL,
      0.198481,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      1,
      1,
      5.781570,
      4.488782,
      NULL,
      0,
      1.511977,
      1,
      3,
      5.314924,
      NULL,
      NULL,
      0.864702,
      0,
      NULL,
      NULL,
      5,
      1.899455,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.995214,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.983135,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.740048,
      NULL,
      NULL,
      NULL,
      NULL,
      5.805444,
      0.772728,
      0,
      4,
      0.196285,
      1,
      1.184520,
      NULL,
      NULL,
      NULL,
      1.591717,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      1,
      3.176162,
      0,
      1.842369,
      1.843363,
      1.696180,
      NULL,
      1,
      1,
      1.905854,
      NULL,
      1.649779,
      NULL,
      0,
      NULL,
      0,
      0.826679,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.115117,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      '21113',
      NULL,
      NULL,
      0.943995,
      NULL,
      '',
      NULL,
      4.738919,
      '4443',
      '3401',
      '',
      1.599577,
      3,
      3.248445,
      2.939080,
      2,
      0,
      0.408192,
      2,
      2);
commit;
end;
/


