set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8703287';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-1-29 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '344',
      '20123132',
      46,
      66,
      '3403202',
      153.402501,
      4,
      1.035422,
      0,
      '440413',
      2.414299,
      NULL,
      27,
      14.182899,
      0,
      NULL,
      1.427511,
      1.193661,
      0.557956,
      NULL,
      1,
      1.098390,
      1.306567,
      0,
      NULL,
      NULL,
      NULL,
      0.506263,
      0.328367,
      0.911384,
      0.518617,
      1,
      4.740170,
      1,
      0.596236,
      NULL,
      1.332140,
      1,
      3.408882,
      1,
      0,
      1,
      2.219766,
      NULL,
      NULL,
      NULL,
      0.940952,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.858336,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.147068,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.993120,
      0.452160,
      4,
      0.105596,
      3.645603,
      1,
      0.546871,
      0,
      1.115633,
      0,
      1.380165,
      0.909863,
      1.956138,
      0,
      0,
      NULL,
      0.864370,
      1,
      NULL,
      NULL,
      NULL,
      1.848243,
      1.226765,
      0.166702,
      1,
      1,
      0,
      1.433528,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.409163,
      NULL,
      NULL,
      NULL,
      1.915965,
      5,
      4,
      1,
      1,
      NULL,
      5,
      0.139071,
      NULL,
      1.539393,
      0.831885,
      NULL,
      NULL,
      2.594962,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.946388,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.800719,
      0.190747,
      NULL,
      NULL,
      NULL,
      4,
      0.191019,
      1,
      NULL,
      1.413298,
      NULL,
      0.668966,
      NULL,
      NULL,
      NULL,
      1,
      1.283113,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.751215,
      2.465070,
      0,
      3.994527,
      0.374203,
      0,
      NULL,
      1,
      1.428517,
      NULL,
      0.970390,
      1.835051,
      1.686773,
      1.965730,
      NULL,
      1.748599,
      0.805448,
      NULL,
      0.311168,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.236519,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      5,
      '31101',
      '44142',
      '',
      1,
      '',
      '',
      '',
      2.959375,
      NULL,
      NULL,
      NULL,
      0,
      3,
      0,
      NULL,
      0,
      3,
      0.827739,
      3.563526,
      NULL);
commit;
end;
/


