set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8703287';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-2-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '320',
      '04044111',
      11,
      51.752002,
      '0230333',
      132,
      6,
      3.537555,
      0,
      '011332',
      NULL,
      '10-19-1981',
      23,
      29.852063,
      0,
      NULL,
      0.709594,
      1,
      2.731420,
      1.809202,
      0.898436,
      0.779946,
      0.773728,
      1,
      2,
      1.194707,
      2,
      1,
      0,
      1,
      1.406127,
      0.271229,
      0,
      1,
      NULL,
      1.357595,
      0.904056,
      0,
      2,
      0,
      2.633241,
      1.553867,
      3,
      0.849381,
      NULL,
      NULL,
      0.214337,
      NULL,
      NULL,
      1.365742,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.312233,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.405781,
      3.210333,
      5.377802,
      1.607700,
      2.617727,
      1,
      0,
      1.743460,
      1.302064,
      0,
      1.513855,
      1,
      1,
      0,
      0,
      0,
      1.391465,
      0.464448,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0.825577,
      1.039235,
      NULL,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      0,
      NULL,
      0.659719,
      0,
      NULL,
      4.629413,
      NULL,
      0.610918,
      NULL,
      5,
      1.903353,
      1.917729,
      1.557257,
      0.767203,
      NULL,
      NULL,
      9,
      1.649220,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.593955,
      1.680466,
      1,
      0,
      0.093566,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.279555,
      NULL,
      0.923109,
      NULL,
      NULL,
      NULL,
      3.045912,
      0.103152,
      NULL,
      0.035319,
      1,
      0,
      0.526926,
      NULL,
      NULL,
      NULL,
      0.427001,
      1.507508,
      0.595829,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.904328,
      0.435403,
      1.868011,
      NULL,
      2.051205,
      0.501229,
      NULL,
      1.588445,
      0.785915,
      NULL,
      0.016580,
      0.348428,
      NULL,
      1,
      1.304424,
      1.003091,
      0,
      0.993594,
      1,
      1.717677,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      4,
      '41113',
      '34444',
      '',
      1,
      '',
      NULL,
      '',
      2.117389,
      '0313',
      '4201',
      '',
      NULL,
      NULL,
      3,
      1,
      2.517626,
      1.704179,
      NULL,
      3,
      3.843492);
commit;
end;
/


