set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7736166';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-10-22 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '2',
      NULL,
      NULL,
      '3200110',
      19.247018,
      3,
      1,
      NULL,
      NULL,
      1.225024,
      '11-15-1988',
      9.343065,
      NULL,
      0.521506,
      NULL,
      0,
      1.662180,
      0.382660,
      NULL,
      1.436251,
      0,
      1.780856,
      NULL,
      1,
      NULL,
      1.936069,
      0.893381,
      1,
      0,
      0.129375,
      2,
      NULL,
      1.576125,
      0.300271,
      1.135356,
      1,
      NULL,
      NULL,
      1,
      5,
      0,
      0.481883,
      1.989248,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.705292,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1.857879,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      1.367565,
      0.311586,
      1.938631,
      0.443238,
      NULL,
      0.452173,
      0.667452,
      NULL,
      0,
      0,
      0,
      1,
      NULL,
      1,
      NULL,
      1.326682,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1,
      3,
      1,
      NULL,
      3.522902,
      NULL,
      NULL,
      4.139278,
      0.814028,
      0.138148,
      1,
      NULL,
      1.002185,
      1,
      NULL,
      NULL,
      9.810072,
      0.788196,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.623590,
      4,
      0,
      1,
      1,
      NULL,
      1.335931,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.365197,
      NULL,
      NULL,
      NULL,
      NULL,
      1.779667,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.166974,
      2.312380,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      5,
      3,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.940951,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.229131,
      0,
      1.447973,
      1,
      1,
      0,
      0.339763,
      0,
      0,
      0.811070,
      0,
      1,
      1.895612,
      1.415137,
      0.626485,
      0,
      0.526616,
      1.823122,
      0.077702,
      0.582055,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      '04420',
      '20142',
      '44240',
      1,
      NULL,
      '',
      NULL,
      0.326440,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


