set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7736166';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-10-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '2',
      NULL,
      NULL,
      '0043442',
      NULL,
      5,
      1,
      NULL,
      '003323',
      2,
      ' 4-27-1987',
      21,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0,
      1.268891,
      0,
      0,
      1,
      0,
      NULL,
      0,
      0.303630,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      0.447668,
      1,
      0,
      0,
      0.773978,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.990918,
      0.792676,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.350683,
      0,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.521910,
      1,
      0.786278,
      1,
      1,
      1.096416,
      NULL,
      NULL,
      0,
      1,
      0.790706,
      0,
      NULL,
      1,
      1.827488,
      1,
      1.956639,
      NULL,
      NULL,
      0.177149,
      1.994850,
      NULL,
      NULL,
      0,
      0.846921,
      1,
      5,
      1,
      1.956068,
      1,
      0.249159,
      0.304487,
      1,
      NULL,
      0,
      8.684969,
      NULL,
      8.674461,
      0,
      NULL,
      7,
      7.484360,
      1.862047,
      0,
      8,
      1,
      NULL,
      NULL,
      NULL,
      5,
      1.727867,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.806555,
      3.103104,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.408127,
      0,
      1,
      1.186289,
      2,
      4,
      NULL,
      NULL,
      NULL,
      0.978629,
      5,
      1.955126,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.129944,
      1.069541,
      1,
      NULL,
      0.171124,
      0.712327,
      0,
      0,
      0,
      0,
      1,
      1,
      NULL,
      0.421104,
      NULL,
      0.691109,
      1,
      1,
      NULL,
      0.186645,
      0.763693,
      1.739692,
      1,
      0.130662,
      1.450543,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.880063,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.340489,
      0,
      2.255403,
      NULL,
      1,
      0,
      0,
      0.227891,
      0.593871,
      NULL,
      NULL,
      NULL,
      NULL,
      1.545646,
      NULL,
      NULL,
      NULL,
      NULL,
      0.571411,
      2,
      2,
      7.849486,
      3,
      NULL,
      0,
      1,
      4,
      '22233',
      '10041',
      NULL,
      NULL,
      NULL,
      '',
      '',
      1.186936,
      '',
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


