set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7736166';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-3-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '3',
      NULL,
      NULL,
      '4341002',
      53.787098,
      0,
      3,
      2,
      '344340',
      1,
      '10-24-2003',
      32,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.499195,
      1.442872,
      NULL,
      0,
      1.121356,
      0.663673,
      0.018504,
      1,
      NULL,
      1,
      NULL,
      1.660658,
      0.504647,
      3,
      1.003238,
      0.411039,
      0.634884,
      1.186874,
      0,
      1,
      4.456465,
      0,
      3,
      1,
      5.784673,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.327997,
      1.211284,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.569775,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      4,
      1,
      2,
      0,
      1,
      1,
      1,
      0.626817,
      1.582559,
      1,
      1,
      0.087447,
      1.133695,
      1,
      1.622263,
      0.114292,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0,
      0.720013,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1.679342,
      5.994885,
      1.818736,
      1,
      7,
      9,
      6.593069,
      9,
      6,
      0,
      NULL,
      9,
      1,
      3,
      NULL,
      1,
      NULL,
      NULL,
      4,
      1.897197,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.543551,
      1.978520,
      0,
      1,
      1.164281,
      0,
      1.982440,
      1.454582,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9.838555,
      0.324210,
      1,
      0.595515,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.930981,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      2.483601,
      NULL,
      2,
      0.988323,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.658485,
      1.117848,
      1,
      1,
      1.535795,
      0,
      NULL,
      NULL,
      2,
      1,
      NULL,
      1,
      0,
      NULL,
      1,
      0,
      NULL,
      0.932361,
      3.400774,
      0.516415,
      NULL,
      1,
      1.270867,
      NULL,
      3.639322,
      2,
      1,
      1.785120,
      1.861141,
      0,
      1,
      0.857873,
      0,
      NULL,
      0.791241,
      0,
      1.951161,
      1.639642,
      0,
      0.672640,
      0.579536,
      0.224701,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.520530,
      2.842011,
      0.512665,
      2,
      0,
      1,
      NULL,
      1.114204,
      NULL,
      NULL,
      NULL,
      NULL,
      0.528794,
      NULL,
      NULL,
      NULL,
      NULL,
      0.252506,
      0.969631,
      NULL,
      3.516444,
      3,
      NULL,
      1,
      2,
      4,
      NULL,
      '34423',
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


