set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7736166';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-9-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '400',
      '12',
      30.555151,
      8.409801,
      NULL,
      131.991212,
      NULL,
      3,
      NULL,
      '330410',
      5,
      '11-15-1980',
      26,
      NULL,
      NULL,
      NULL,
      0.741350,
      0.629610,
      3,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0,
      1.153017,
      5,
      1,
      1.895474,
      1.914882,
      0.359225,
      1,
      NULL,
      NULL,
      1,
      1,
      0.801218,
      NULL,
      1,
      1,
      3,
      1,
      3.211003,
      0.091466,
      NULL,
      NULL,
      0.778256,
      NULL,
      NULL,
      1.332144,
      NULL,
      1,
      0.233348,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.745460,
      0.145064,
      1.090301,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.360541,
      1.460636,
      NULL,
      3.359173,
      1.192622,
      NULL,
      0,
      1.404195,
      1,
      NULL,
      1,
      0,
      0,
      1.782771,
      0,
      1.513836,
      NULL,
      0,
      NULL,
      1.628932,
      1,
      0,
      1.172812,
      1.299395,
      0.135636,
      1.238543,
      1,
      2,
      1,
      0,
      1.488479,
      0,
      1,
      4.260275,
      0.996305,
      6.515706,
      2,
      NULL,
      0,
      NULL,
      0.442708,
      4.886276,
      6,
      NULL,
      0,
      1.637047,
      1,
      1.118105,
      NULL,
      NULL,
      3.068575,
      1.054209,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.240757,
      NULL,
      0,
      0,
      0.260634,
      0.607771,
      1.054185,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.673171,
      NULL,
      1,
      1.673392,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.193409,
      6,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      5.449674,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.449356,
      NULL,
      0.802785,
      3,
      1,
      0.727994,
      2.920219,
      NULL,
      0,
      NULL,
      0.879380,
      0,
      1,
      0.268974,
      0,
      1.973045,
      1.507946,
      NULL,
      0.910300,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.448653,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      '31330',
      '20104',
      '',
      NULL,
      '',
      NULL,
      '',
      0.995859,
      NULL,
      '',
      NULL,
      2.123263,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


