set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7736166';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-3-31 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '00',
      NULL,
      3.933582,
      '0343334',
      45.338412,
      0,
      NULL,
      0,
      NULL,
      NULL,
      ' 7- 9-1987',
      12.632849,
      NULL,
      1,
      NULL,
      0,
      0.821182,
      2.170009,
      1,
      0,
      NULL,
      0.173713,
      1,
      0,
      1.006737,
      0,
      1.205159,
      0,
      NULL,
      NULL,
      0,
      0.615315,
      1,
      0.385232,
      1.864829,
      0.317132,
      0.360241,
      2.741386,
      0,
      NULL,
      NULL,
      0,
      0.301875,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.181315,
      1,
      0,
      NULL,
      NULL,
      1,
      0,
      1.132765,
      1.104388,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0,
      4.473884,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.939512,
      NULL,
      NULL,
      0.320487,
      0.827022,
      1.397054,
      1.937423,
      NULL,
      1.707170,
      1,
      0,
      1,
      1,
      1.109153,
      NULL,
      NULL,
      0,
      0,
      1.526644,
      1,
      0,
      1,
      NULL,
      0.579821,
      0,
      1.770358,
      0,
      1,
      0.827230,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.136757,
      NULL,
      1.633231,
      0,
      NULL,
      4,
      0.406183,
      6,
      2,
      NULL,
      2,
      5.293306,
      1,
      3,
      1,
      0,
      NULL,
      NULL,
      6,
      0.009036,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.286914,
      1,
      1,
      0,
      1.791945,
      0.790861,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      NULL,
      0,
      3,
      NULL,
      0,
      2,
      NULL,
      3,
      5.730971,
      3.207558,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1.929089,
      0,
      1.528515,
      NULL,
      NULL,
      NULL,
      0,
      0.956468,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.192978,
      0.626980,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1.822626,
      NULL,
      0,
      0.466038,
      0.597235,
      0.091541,
      1,
      1,
      0.831743,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.455437,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.019976,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.030620,
      NULL,
      NULL,
      NULL,
      NULL,
      1.517170,
      NULL,
      NULL,
      NULL,
      NULL,
      1.338608,
      1,
      0,
      NULL,
      1.706866,
      NULL,
      1.070486,
      1,
      3,
      '22241',
      '23442',
      '',
      0.600016,
      '',
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


