set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7736166';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-9-22 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '22',
      15,
      8.218852,
      '4133143',
      156.254776,
      1,
      NULL,
      NULL,
      '221301',
      5.745994,
      NULL,
      NULL,
      43,
      0.806462,
      NULL,
      1.972670,
      1.015557,
      2,
      0,
      0.566721,
      0.050168,
      0.737447,
      1.702111,
      1.122334,
      NULL,
      2,
      NULL,
      0.619745,
      0.397475,
      1,
      2.513634,
      0,
      2.564967,
      0.314531,
      1.274762,
      NULL,
      NULL,
      3,
      0,
      3,
      0,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.437949,
      NULL,
      0,
      NULL,
      NULL,
      1.206865,
      0,
      0.284238,
      0.314892,
      2,
      0.746481,
      3,
      0.821948,
      1,
      3,
      NULL,
      0,
      0,
      1.697534,
      5.541131,
      0,
      NULL,
      4,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      3.108476,
      2.615736,
      1,
      NULL,
      0,
      NULL,
      1.970679,
      1,
      1.396769,
      1,
      1,
      NULL,
      1.032231,
      1,
      0.174662,
      1.860380,
      0,
      1.318960,
      NULL,
      0.851661,
      0,
      1,
      1.521572,
      0.877156,
      NULL,
      0.523168,
      1.677109,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.983492,
      1,
      0,
      2.607801,
      4.933099,
      3.162097,
      6,
      NULL,
      1,
      NULL,
      2,
      1.567672,
      0,
      1,
      0,
      0.330776,
      NULL,
      NULL,
      6,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1.890538,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.830298,
      NULL,
      NULL,
      NULL,
      1,
      0.951805,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      6,
      NULL,
      5.684974,
      0,
      5.313951,
      1.899898,
      NULL,
      NULL,
      1,
      2.774262,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.172979,
      0.516094,
      2,
      1,
      0.408490,
      1,
      0,
      3.311677,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0,
      1.995059,
      0.392794,
      0.942800,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.952892,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.956579,
      NULL,
      NULL,
      NULL,
      NULL,
      0.416159,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.149525,
      0,
      NULL,
      1.156750,
      1,
      1.030722,
      2,
      5,
      '23222',
      '30011',
      '',
      0,
      NULL,
      '',
      '',
      1,
      '',
      NULL,
      '',
      1.264280,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


