set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7736166';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-3-02 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '130',
      '43',
      23,
      1,
      '1003224',
      23.179141,
      6,
      NULL,
      1,
      '343110',
      0.519324,
      ' 2- 3-1998',
      39,
      4.540194,
      0,
      NULL,
      1.403786,
      0.647123,
      0.609189,
      1,
      1.334003,
      0,
      0.933633,
      1.511586,
      NULL,
      0,
      0,
      1,
      NULL,
      0,
      0.149103,
      2.893682,
      2,
      1,
      1.966677,
      0,
      2.637533,
      3,
      4.928003,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      3,
      1.357080,
      0.839314,
      NULL,
      3.536198,
      1,
      1,
      NULL,
      0,
      2.047346,
      1,
      NULL,
      NULL,
      1,
      0.917479,
      0.176399,
      2.956990,
      0,
      0.677713,
      1.195524,
      1,
      2,
      1.375385,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      5,
      NULL,
      NULL,
      1.605119,
      NULL,
      1.295377,
      0.740762,
      0.551515,
      0,
      0,
      1,
      0.686648,
      0,
      1.366571,
      1.718136,
      0,
      0.996699,
      NULL,
      0.785540,
      1,
      1.414708,
      NULL,
      NULL,
      0.831537,
      1.020106,
      1,
      NULL,
      1,
      1.432866,
      NULL,
      NULL,
      1.325197,
      1,
      1,
      4.852486,
      NULL,
      NULL,
      9.095765,
      NULL,
      5.204448,
      NULL,
      1,
      4.687453,
      0,
      1.003215,
      1.010626,
      0,
      NULL,
      NULL,
      0.034100,
      1.783995,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      2,
      1,
      0,
      1,
      1,
      1.182887,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      NULL,
      1,
      3.535239,
      1.834787,
      0.543140,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.359543,
      3.019673,
      0,
      NULL,
      NULL,
      NULL,
      5.054285,
      1,
      NULL,
      0,
      4,
      1,
      1.711747,
      1.843113,
      NULL,
      NULL,
      0,
      2.170678,
      1.460054,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.103785,
      1,
      NULL,
      1.311613,
      0,
      NULL,
      0.786088,
      0.063706,
      0,
      0,
      1,
      1,
      NULL,
      0,
      1.569593,
      1,
      0.103176,
      1.150876,
      NULL,
      0,
      0,
      0,
      1.862076,
      0.543230,
      2.145869,
      2,
      NULL,
      NULL,
      1,
      0.375700,
      0,
      0,
      1.623191,
      0.225066,
      0.737678,
      0.111541,
      0,
      0,
      0.787231,
      0.769576,
      0,
      3,
      1.369512,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.513975,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.975445,
      NULL,
      NULL,
      NULL,
      NULL,
      1.056406,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0.058171,
      1,
      5.188870,
      '12414',
      '31140',
      NULL,
      NULL,
      '',
      NULL,
      '',
      NULL,
      '',
      NULL,
      '',
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


