set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7736166';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-9-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '002',
      '33',
      NULL,
      7,
      '4130234',
      118,
      NULL,
      1.430156,
      2,
      NULL,
      4.215276,
      ' 4- 2-1993',
      27.054334,
      71,
      0.392551,
      NULL,
      0.862061,
      0.978734,
      3,
      0,
      NULL,
      1,
      1.030605,
      1,
      2,
      0.986592,
      2,
      0.509622,
      1,
      1,
      1.791164,
      3,
      0,
      1.180416,
      0.788756,
      1,
      NULL,
      0,
      0.391474,
      0,
      2,
      NULL,
      NULL,
      0.961066,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.152269,
      0,
      0.979920,
      2.757928,
      1,
      1,
      NULL,
      NULL,
      1,
      1.447283,
      1,
      0,
      3.123791,
      0,
      NULL,
      2,
      0,
      1.967617,
      0.343261,
      NULL,
      0,
      NULL,
      5,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1.667829,
      NULL,
      NULL,
      NULL,
      0,
      2,
      0,
      NULL,
      1,
      0,
      1,
      0,
      1.008817,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      1.988081,
      1,
      1,
      1,
      NULL,
      0,
      1.143144,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.056636,
      0.555211,
      NULL,
      2,
      3.564588,
      NULL,
      NULL,
      4,
      4,
      3.164298,
      8,
      1.693183,
      1,
      0,
      1.697589,
      NULL,
      NULL,
      3,
      1.702540,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.479071,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1.121457,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.772847,
      NULL,
      9,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1.327674,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      1.967794,
      1,
      0.781137,
      0,
      3,
      NULL,
      NULL,
      NULL,
      1,
      5.582088,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.335041,
      0.982645,
      3,
      0.775472,
      0.726116,
      1.781884,
      NULL,
      0,
      1.649770,
      1,
      2.821635,
      0,
      1,
      1,
      NULL,
      0.469791,
      NULL,
      NULL,
      1.448319,
      0.567051,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.656991,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.569755,
      1,
      0.139926,
      2,
      2.868333,
      NULL,
      NULL,
      '',
      0.153310,
      '',
      '',
      '',
      1,
      '',
      '',
      NULL,
      1.406414,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


