set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7736166';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-3-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '043',
      '04',
      25.761156,
      15.981686,
      '2323302',
      182,
      2,
      3,
      3,
      '400200',
      4.967224,
      ' 0- 5-1994',
      NULL,
      7,
      1,
      NULL,
      NULL,
      NULL,
      2.866539,
      0,
      1,
      0.580414,
      1,
      NULL,
      1.772979,
      NULL,
      2.814715,
      NULL,
      1.346569,
      4.890927,
      1,
      7.773238,
      NULL,
      7,
      0.616094,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      2,
      5,
      0.887090,
      NULL,
      NULL,
      0.084409,
      NULL,
      NULL,
      5,
      NULL,
      0.019976,
      NULL,
      NULL,
      0,
      1,
      0,
      1.878708,
      3,
      3,
      2.473820,
      2,
      0,
      3.205788,
      1.728581,
      0.589990,
      NULL,
      1.722131,
      4,
      2,
      0.226439,
      4.246343,
      0,
      0,
      1.828176,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.773972,
      2.785661,
      2,
      0.148266,
      0,
      0,
      1.223287,
      NULL,
      1,
      1.302097,
      0,
      0,
      0.177675,
      1,
      0.812457,
      0.930926,
      NULL,
      1,
      1,
      NULL,
      0,
      1,
      NULL,
      0,
      NULL,
      1,
      0.437870,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2.116467,
      1.692267,
      5,
      2.246323,
      NULL,
      6,
      6,
      6.248207,
      NULL,
      7,
      4,
      3,
      NULL,
      1.081281,
      1,
      1,
      1.090226,
      0.299441,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.136216,
      2,
      0,
      2,
      NULL,
      1.577332,
      1.551313,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.263033,
      NULL,
      6,
      2.687583,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.645779,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.720867,
      1.963397,
      6.308179,
      NULL,
      0,
      1,
      0.828713,
      1.444454,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.467885,
      1.991542,
      2.691444,
      0,
      1.861850,
      0.846594,
      1.712034,
      NULL,
      1,
      2.540904,
      2.314542,
      0,
      0.336006,
      0.408155,
      0.072551,
      1,
      0,
      1,
      0.431702,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.331500,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      5,
      '40242',
      '11440',
      NULL,
      0.090894,
      NULL,
      '',
      '',
      0,
      '',
      '',
      '',
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


