set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7736166';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-9-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '234',
      NULL,
      43.702793,
      10,
      '0411131',
      176.275227,
      4,
      0.025222,
      NULL,
      '440322',
      1.235821,
      ' 9-27-1989',
      46.274008,
      17.688099,
      0,
      NULL,
      NULL,
      1,
      3,
      NULL,
      1.211870,
      0,
      1.564463,
      NULL,
      2,
      0.778188,
      1,
      0.114571,
      1.027460,
      1.117673,
      1.963230,
      4.111886,
      0,
      3,
      0,
      0.973836,
      0,
      1.078873,
      7.833117,
      0,
      0,
      0,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      0.760600,
      1.433065,
      NULL,
      1.239400,
      1.341841,
      0.099244,
      1,
      NULL,
      1.311290,
      2,
      1.610482,
      1,
      1.968088,
      0.736098,
      NULL,
      0.315474,
      1.645143,
      NULL,
      1.870132,
      1.073799,
      0.243575,
      1.601600,
      1,
      0,
      0,
      0.741742,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.735454,
      3.186228,
      NULL,
      4.391796,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0.614922,
      0,
      0,
      1.991391,
      NULL,
      1.473403,
      1.479886,
      0.032079,
      NULL,
      NULL,
      NULL,
      1.040988,
      1,
      NULL,
      0.316776,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3.775843,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0,
      5,
      NULL,
      4,
      1.827125,
      0.718678,
      6.495965,
      1,
      3.320217,
      1.435047,
      0.635072,
      0.685221,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.779674,
      1.979994,
      NULL,
      0,
      0,
      0.324441,
      1.544108,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.197840,
      NULL,
      4.477236,
      3.448779,
      2.688583,
      1.499141,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.065645,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.018211,
      0,
      NULL,
      5.841583,
      0.127258,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      3,
      0.445353,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.813838,
      1.006558,
      0,
      0,
      1,
      1,
      0.163276,
      1,
      0.038215,
      1,
      1.446038,
      1,
      0.124789,
      1,
      NULL,
      0.309911,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.567549,
      1.543687,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.951219,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.788263,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      1,
      NULL,
      0.836095,
      NULL,
      1,
      1,
      3.115996,
      '13112',
      '41442',
      '',
      1.231546,
      '',
      '',
      NULL,
      3.413120,
      NULL,
      '',
      NULL,
      NULL,
      3.616886,
      2,
      2,
      0,
      1.534514,
      0,
      3,
      0.220160);
commit;
end;
/


