set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7736166';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-3-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '03214121',
      35.955693,
      19.635920,
      NULL,
      189,
      3,
      1,
      1,
      '234332',
      5,
      ' 4-10-1979',
      41.995697,
      12.195663,
      1,
      NULL,
      0,
      1,
      2.025866,
      1.101496,
      1,
      0.203266,
      0,
      1,
      0,
      NULL,
      0,
      1.993161,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      4.340700,
      0.934891,
      0.289030,
      0.000415,
      0,
      NULL,
      1,
      NULL,
      1,
      1,
      1.961770,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0.797071,
      NULL,
      3,
      1.524548,
      1,
      1.456469,
      0,
      1,
      0.249222,
      0,
      2.922586,
      0,
      1,
      2.020779,
      2,
      0.879139,
      1.748611,
      0,
      NULL,
      NULL,
      1.329394,
      0,
      NULL,
      1,
      1.965749,
      0,
      NULL,
      NULL,
      0.511393,
      NULL,
      NULL,
      1.667428,
      0.375336,
      1.475837,
      0.375671,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0.339169,
      NULL,
      1,
      1.622562,
      0,
      1.580580,
      1.501616,
      0,
      0,
      0,
      NULL,
      0,
      1.314059,
      0,
      1.924772,
      1,
      0.429547,
      NULL,
      0,
      1,
      0,
      0.923814,
      1.726603,
      0,
      1,
      1,
      1.292272,
      0,
      3.347276,
      NULL,
      1.480735,
      2.671623,
      NULL,
      1.741290,
      4.368330,
      0,
      1.780617,
      1.613029,
      2,
      2,
      0.550091,
      0.389312,
      7,
      0.383730,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.323888,
      2,
      0,
      0,
      1.141807,
      1.881710,
      0.506893,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      7.460006,
      1.771750,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.343685,
      1.717296,
      6.683239,
      0,
      1.731560,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0.087625,
      NULL,
      0.807670,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.431503,
      1,
      2.250905,
      1.824401,
      1.127616,
      1.678069,
      0.961305,
      2.809607,
      NULL,
      2.840765,
      NULL,
      0,
      NULL,
      1.613971,
      0.832686,
      NULL,
      1,
      0,
      1,
      0.699818,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.869070,
      '30401',
      '34122',
      '',
      1.629030,
      '',
      '',
      '',
      5.984869,
      '03113',
      '30120',
      '',
      NULL,
      NULL,
      2.259458,
      4.163937,
      2.191364,
      NULL,
      1.291623,
      3.932494,
      0);
commit;
end;
/


