set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7736166';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-10-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '333',
      '32334421',
      16.979748,
      31.070880,
      NULL,
      NULL,
      5,
      2.503941,
      0,
      NULL,
      2,
      ' 7- 4-2003',
      49.526426,
      45.022474,
      1.790338,
      NULL,
      3.240741,
      3,
      1,
      0,
      0,
      2.358507,
      0,
      1.489697,
      3.321002,
      0,
      2,
      0.920879,
      NULL,
      1,
      1.032991,
      NULL,
      1,
      NULL,
      0,
      1.677080,
      0.658405,
      1.871522,
      NULL,
      NULL,
      3,
      3.554269,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.616048,
      2.669811,
      0.520732,
      1.083440,
      1,
      NULL,
      2,
      3.905559,
      1,
      0,
      NULL,
      1.160177,
      1.515026,
      NULL,
      1,
      NULL,
      0.643686,
      NULL,
      1,
      0,
      4,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.372420,
      NULL,
      NULL,
      0.809790,
      1,
      4.574584,
      0,
      3,
      NULL,
      0.706970,
      1,
      1,
      1.682213,
      NULL,
      0.498822,
      NULL,
      0.352097,
      1.258010,
      0.830267,
      0,
      1,
      1.997900,
      NULL,
      0,
      0,
      0.912778,
      0.151177,
      0,
      0,
      1.992928,
      NULL,
      3.672417,
      1.977815,
      NULL,
      1,
      1,
      NULL,
      3,
      1.534758,
      4,
      7,
      3.045915,
      8.705857,
      NULL,
      9.481713,
      1.455611,
      5.801708,
      7.069884,
      1.590531,
      NULL,
      0.748147,
      1,
      0.942480,
      0.699017,
      8.851517,
      0.323661,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.654932,
      1,
      1,
      NULL,
      0.520276,
      1.596190,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.614169,
      NULL,
      0.541806,
      0.315933,
      2.058972,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1.826004,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0.254697,
      5.337211,
      NULL,
      4.352396,
      0,
      0.219029,
      0.719924,
      NULL,
      NULL,
      1.349466,
      5,
      1.003274,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.722456,
      0,
      3,
      0.901180,
      1,
      1.360338,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.990402,
      1.094704,
      0.885568,
      0.168849,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.068108,
      0.549467,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.148991,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.330454,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.291390,
      0.723037,
      0.190565,
      0,
      0,
      '11400',
      NULL,
      '',
      0,
      '',
      NULL,
      '',
      0.867931,
      '23442',
      '32331',
      '',
      3.371696,
      NULL,
      NULL,
      0,
      1,
      0.610745,
      1,
      1,
      2);
commit;
end;
/


