set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7736166';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-3-02 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '04010211',
      57.316471,
      34.646737,
      '0243201',
      118,
      1,
      0,
      3,
      NULL,
      5,
      ' 2- 0-1985',
      36,
      2.025614,
      1.481027,
      NULL,
      3.657288,
      0.825779,
      1.271538,
      NULL,
      0,
      0.951669,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0,
      1,
      0,
      1.283546,
      NULL,
      0.046036,
      1,
      0,
      0.890192,
      4,
      NULL,
      6,
      NULL,
      3,
      1.286988,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      1,
      3.413818,
      NULL,
      1.787086,
      0,
      0,
      1.151965,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      NULL,
      1,
      1,
      1,
      1.352495,
      5.289798,
      0,
      1,
      0.179528,
      0,
      2,
      0.462281,
      1.375804,
      NULL,
      NULL,
      1.252281,
      NULL,
      NULL,
      0,
      NULL,
      4,
      0,
      3,
      0,
      0.289287,
      1,
      NULL,
      0,
      1,
      1.575252,
      NULL,
      NULL,
      1.334550,
      1,
      1,
      1,
      NULL,
      NULL,
      1,
      1.745564,
      NULL,
      0.405052,
      0.250702,
      1,
      1.309428,
      0,
      NULL,
      NULL,
      1.614259,
      3,
      1.043475,
      1,
      NULL,
      1.970212,
      6.200350,
      NULL,
      NULL,
      4.187379,
      5.094828,
      5,
      5,
      2.287719,
      4.576871,
      0,
      NULL,
      1,
      1,
      1.439015,
      NULL,
      8,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1,
      0.912312,
      1,
      1.487895,
      0.021260,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      9,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.338127,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.327068,
      NULL,
      NULL,
      0,
      1.113604,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.963259,
      0,
      3,
      1.513132,
      2,
      NULL,
      1.611278,
      3,
      0.382893,
      NULL,
      1.586260,
      NULL,
      0.768206,
      1.144092,
      0,
      NULL,
      0,
      0,
      0.863495,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.772744,
      1.381179,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.431368,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1.219063,
      NULL,
      NULL,
      0,
      0.192123,
      '20141',
      NULL,
      '',
      0,
      NULL,
      '',
      NULL,
      0.461050,
      '4130',
      NULL,
      '41021',
      NULL,
      5,
      3,
      0,
      2,
      NULL,
      2,
      NULL,
      2.144119);
commit;
end;
/


