set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7736166';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-10-09 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '411',
      '24222424',
      74.667104,
      76.568702,
      '2144223',
      144,
      3,
      2,
      NULL,
      '011403',
      0.984937,
      ' 1-28-1995',
      36.240192,
      51.542182,
      1,
      NULL,
      1,
      2.856257,
      1.026404,
      0,
      1,
      2,
      1.428871,
      0,
      0,
      NULL,
      4.760279,
      1.337433,
      0,
      1.976951,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      5.663375,
      5,
      1,
      2.460965,
      2,
      4,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.910061,
      NULL,
      1,
      3.006087,
      1,
      1.322798,
      0,
      1,
      1,
      2,
      3.244807,
      2,
      1.232873,
      NULL,
      NULL,
      3.082158,
      1,
      NULL,
      0,
      1.657689,
      1,
      0,
      1.768714,
      1,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.678640,
      2,
      NULL,
      NULL,
      1,
      1,
      0,
      0.025904,
      0,
      0.237577,
      0,
      1.824455,
      1.134794,
      1,
      NULL,
      0,
      1.532461,
      1.471734,
      NULL,
      1,
      1.243389,
      1,
      0,
      0,
      1.057615,
      0.331083,
      0.546396,
      2,
      1.942837,
      4.078829,
      NULL,
      0,
      1.488981,
      1.281503,
      0.084966,
      1,
      9,
      0,
      6.119199,
      8,
      4,
      1.275185,
      3.523416,
      4.323057,
      0.807029,
      0,
      0.397991,
      1.518893,
      0.713123,
      0.076518,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.244773,
      0,
      1,
      1.667869,
      1.226184,
      0.758884,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      3,
      3.002441,
      1,
      1.154467,
      2.710454,
      NULL,
      1.979172,
      3,
      4,
      0.176861,
      NULL,
      NULL,
      NULL,
      NULL,
      1.618332,
      0,
      0,
      6.133346,
      3.340152,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      6,
      0.877992,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3,
      0,
      0.031371,
      0,
      0,
      2.444498,
      1.884812,
      2.399714,
      2,
      1,
      NULL,
      NULL,
      0,
      0,
      1,
      0.102170,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4,
      '10341',
      '03033',
      '',
      1.338954,
      '',
      '',
      '',
      4,
      NULL,
      NULL,
      '14130',
      3.787952,
      5,
      3.823444,
      0,
      1.393799,
      2,
      2,
      0,
      1);
commit;
end;
/


