set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7736166';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-5-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '130',
      '00133102',
      27.657669,
      21.134572,
      '2122024',
      252.001410,
      3,
      NULL,
      3,
      '042124',
      3,
      ' 8-17-1977',
      9,
      64,
      1.433978,
      NULL,
      3.708582,
      0,
      NULL,
      1.751527,
      0,
      0.729707,
      0,
      0,
      0.874829,
      NULL,
      3,
      1.182651,
      NULL,
      1,
      1.541701,
      NULL,
      2,
      0.692755,
      0,
      1,
      1.843353,
      3.048743,
      4,
      1,
      3.749823,
      0.650249,
      5.188106,
      0.786276,
      NULL,
      NULL,
      1.136931,
      NULL,
      NULL,
      5.930771,
      1.548178,
      1.653921,
      NULL,
      1.353650,
      1.763781,
      0,
      3,
      1,
      3,
      2.820164,
      0,
      1.572138,
      1,
      1.943777,
      3,
      0,
      1,
      0.864522,
      NULL,
      NULL,
      0.642417,
      6.091042,
      NULL,
      NULL,
      NULL,
      1.070830,
      NULL,
      NULL,
      0.007144,
      NULL,
      NULL,
      0,
      NULL,
      3,
      NULL,
      5,
      1.904930,
      0,
      1,
      0.842560,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0,
      NULL,
      0,
      0,
      1.233875,
      0,
      1.730768,
      1,
      0.642176,
      NULL,
      NULL,
      0.696834,
      1.619562,
      0,
      1.373071,
      0.803703,
      1.113191,
      NULL,
      6,
      NULL,
      NULL,
      NULL,
      1,
      6.305924,
      2.888454,
      1.012839,
      NULL,
      1.649381,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.678984,
      1.899731,
      NULL,
      1,
      NULL,
      1,
      4,
      0.822517,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.429819,
      2,
      0,
      3,
      3.364368,
      3,
      1,
      1.484598,
      4.854279,
      6,
      2.817727,
      0.052119,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.836976,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      1.391043,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.302913,
      1,
      0.565040,
      2,
      0,
      1,
      0.288494,
      0,
      2.600564,
      3.324020,
      NULL,
      NULL,
      1,
      1,
      1,
      3,
      1,
      1,
      NULL,
      0,
      1,
      0.715390,
      3.714126,
      NULL,
      0.343691,
      3.080485,
      1,
      NULL,
      0.012647,
      1,
      NULL,
      NULL,
      0.476236,
      1.958115,
      0.103668,
      0.058561,
      0,
      0.709825,
      0,
      0.253580,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '34310',
      '21232',
      '',
      0.171887,
      '',
      '',
      '',
      4,
      '0120',
      '43440',
      '03420',
      3,
      4,
      3.541339,
      1.413533,
      1,
      2.756088,
      NULL,
      3,
      5.470933);
commit;
end;
/


