set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7736166';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-9-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '310',
      '01201330',
      NULL,
      NULL,
      '3411212',
      80.778578,
      6,
      1.531737,
      0,
      '312203',
      3.550472,
      ' 8-27-1981',
      7,
      39,
      0.890080,
      NULL,
      1,
      NULL,
      1,
      0,
      3,
      0.776021,
      0,
      0.118390,
      1,
      NULL,
      2,
      0,
      1,
      0.161886,
      NULL,
      3.646390,
      2,
      1.275796,
      0,
      0.435158,
      NULL,
      3.501659,
      1.133981,
      NULL,
      NULL,
      0.034670,
      1.839811,
      1.464016,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      4.172191,
      0,
      1,
      0.715140,
      1.450178,
      NULL,
      1,
      NULL,
      1,
      1.067922,
      2.227552,
      NULL,
      1,
      0,
      3.960528,
      NULL,
      NULL,
      1.853644,
      0,
      6.097418,
      1,
      1.014892,
      2.042694,
      1,
      1,
      1.092373,
      0.794131,
      NULL,
      NULL,
      0.548745,
      NULL,
      NULL,
      0.537787,
      1.361423,
      3,
      1.597390,
      1.137752,
      1.069170,
      0.927866,
      0.397889,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.500908,
      0.223933,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1.517741,
      0.875282,
      1,
      0,
      0,
      2.793304,
      0.096991,
      NULL,
      1,
      1.217147,
      0,
      3,
      1.690778,
      NULL,
      7,
      9,
      3.957921,
      4,
      0,
      NULL,
      1,
      NULL,
      3.770886,
      0.153665,
      NULL,
      2.591683,
      1,
      1.874340,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.109931,
      0,
      0,
      0,
      1.247422,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.638249,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.311730,
      NULL,
      0.405194,
      NULL,
      NULL,
      NULL,
      0,
      0.432825,
      NULL,
      7,
      NULL,
      2,
      0.360399,
      NULL,
      NULL,
      NULL,
      1.067602,
      3,
      1.433433,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.782446,
      1,
      3,
      1.863035,
      NULL,
      NULL,
      1.522516,
      0.878830,
      NULL,
      1,
      1.977913,
      0.817298,
      0.939507,
      0.315219,
      1.474698,
      1.671379,
      0,
      1.717351,
      0.677437,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      NULL,
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      3,
      '0441',
      '11003',
      NULL,
      NULL,
      NULL,
      1,
      2,
      0,
      3,
      1.677928,
      3.284604,
      2);
commit;
end;
/


