set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7736166';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-4-03 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '430',
      '14143002',
      58,
      NULL,
      '3130041',
      252.352497,
      0,
      1.164245,
      1,
      '230434',
      3,
      ' 8- 9-1989',
      8,
      48,
      NULL,
      NULL,
      1,
      1.529860,
      1,
      1.338362,
      1.141350,
      0,
      0.383565,
      0,
      1,
      0.099985,
      5.629288,
      0.709134,
      0,
      1.507766,
      1.880090,
      7.085080,
      1,
      1.602479,
      1,
      1.198641,
      NULL,
      2,
      5,
      0,
      2,
      NULL,
      2.147851,
      0.243819,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.562566,
      1,
      1,
      0.349565,
      NULL,
      0,
      0,
      1,
      NULL,
      0,
      1,
      1.586891,
      1,
      0.547617,
      1.539340,
      0.385943,
      1.395792,
      0.037421,
      0,
      7.324311,
      5,
      0,
      5,
      0,
      2,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0.015740,
      0.593834,
      1.285451,
      2,
      0,
      NULL,
      0.140637,
      1,
      0,
      1,
      0,
      0.073954,
      0,
      1.495934,
      0.037138,
      0.016232,
      0.754610,
      0.467417,
      NULL,
      1.744860,
      1,
      1,
      0.295542,
      0,
      0.517429,
      1.962649,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      2.494947,
      NULL,
      4,
      6,
      4,
      11,
      4.264161,
      2.221914,
      NULL,
      5,
      1.110874,
      5,
      1,
      1.723882,
      NULL,
      2.026267,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.239515,
      0.487625,
      0,
      0,
      0.665379,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      3.922054,
      1,
      0.901810,
      0.506717,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.876583,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      4.131650,
      1,
      NULL,
      NULL,
      5,
      2,
      1,
      NULL,
      NULL,
      NULL,
      1,
      6.397458,
      1.662279,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.312452,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      2.001610,
      NULL,
      1.884853,
      0.561853,
      NULL,
      0,
      1.692761,
      1,
      NULL,
      0,
      NULL,
      0.098521,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      '43441',
      '00432',
      '',
      NULL,
      NULL,
      '',
      '',
      1.959517,
      NULL,
      '21022',
      '10022',
      NULL,
      2.899270,
      3,
      0.741777,
      0.772918,
      5.925738,
      NULL,
      1.432264,
      3.259628);
commit;
end;
/


