set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7736166';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-9-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '41321240',
      NULL,
      NULL,
      '1331343',
      NULL,
      5,
      3,
      2,
      NULL,
      NULL,
      ' 5- 3-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.775206,
      3.455374,
      0.645608,
      0.212060,
      NULL,
      0,
      NULL,
      2,
      NULL,
      4.751800,
      1.624285,
      0,
      NULL,
      NULL,
      5,
      0.174450,
      0.382564,
      1.075996,
      1,
      5,
      1.539983,
      7,
      0,
      3,
      0.391734,
      2,
      NULL,
      NULL,
      NULL,
      1.168903,
      NULL,
      NULL,
      6,
      1.084049,
      0.461490,
      3,
      1,
      1.253309,
      1.930414,
      NULL,
      1.590575,
      3.261540,
      3.813446,
      0.108347,
      2.450290,
      1.968936,
      NULL,
      3,
      1.098045,
      1.765280,
      0.544805,
      0.703227,
      1,
      1.165480,
      6,
      NULL,
      2,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.694744,
      1,
      NULL,
      0.484344,
      0,
      NULL,
      0.225187,
      0,
      0.603779,
      1.226015,
      0,
      0.442767,
      NULL,
      1,
      1.652846,
      1.441003,
      1,
      1.534743,
      1,
      NULL,
      1.775563,
      NULL,
      NULL,
      0,
      1.521357,
      1.636828,
      1.207963,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.365488,
      2.863813,
      0.144816,
      6,
      4.194376,
      NULL,
      0.432240,
      2.337953,
      10.328103,
      1,
      3,
      0,
      5.439484,
      3.925356,
      0.057961,
      3.775991,
      1,
      0,
      2.876033,
      1.406426,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.386638,
      NULL,
      1,
      1,
      1.086139,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.192943,
      3.752755,
      0.751006,
      1.176086,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.007465,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      9.006470,
      6.448076,
      5.154721,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.477825,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.641487,
      2,
      1,
      2.283287,
      1.272457,
      0,
      3.964288,
      0,
      1,
      1.411105,
      1.884388,
      0,
      NULL,
      NULL,
      0.680062,
      1,
      1.685154,
      NULL,
      1.390588,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.556082,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.952015,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.578749,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.290371,
      NULL,
      NULL,
      NULL,
      NULL,
      1.959842,
      NULL,
      1,
      NULL,
      0,
      0,
      1,
      1,
      4,
      '44442',
      '04023',
      '',
      0,
      '',
      '',
      '',
      1.382632,
      '2021',
      '24404',
      '00410',
      5,
      5.497430,
      NULL,
      NULL,
      NULL,
      0.280088,
      1,
      2,
      2);
commit;
end;
/


