set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7736166';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-4-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1422',
      '44222112',
      32.385800,
      56,
      '1431334',
      76.334513,
      NULL,
      NULL,
      2,
      '413142',
      NULL,
      '10-20-1989',
      31.030255,
      48.886725,
      1,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1.187688,
      0.243155,
      NULL,
      1.354746,
      2,
      1,
      4.473100,
      NULL,
      1,
      1,
      NULL,
      0,
      1.718550,
      0,
      1.889355,
      0.508983,
      0,
      NULL,
      5.376823,
      0,
      0.920109,
      0.447562,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      4.530409,
      1,
      0,
      0.210395,
      NULL,
      NULL,
      0,
      0.964789,
      NULL,
      2.861449,
      1,
      0.122597,
      NULL,
      NULL,
      0,
      3.044501,
      0,
      0,
      NULL,
      5.368295,
      4.104007,
      0.647830,
      4.027536,
      1,
      1,
      0.528928,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0.570165,
      NULL,
      1.057565,
      0,
      0,
      1,
      0.591821,
      1.600718,
      1,
      1,
      0.357793,
      NULL,
      NULL,
      1,
      NULL,
      1.250943,
      NULL,
      0.612551,
      0,
      1,
      1,
      0,
      0,
      0.859310,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.888032,
      5,
      0.540636,
      6.386563,
      6.580315,
      2,
      NULL,
      9,
      NULL,
      7.804832,
      5.045864,
      6.401072,
      3.498905,
      4,
      5,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.340631,
      0,
      NULL,
      0,
      1.403313,
      0.399854,
      0.384968,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      3.694623,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.227779,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      2.457938,
      1,
      5,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.393696,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.177954,
      1,
      NULL,
      2.338023,
      1.409919,
      1.581025,
      0.652252,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.316202,
      NULL,
      0.402737,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.440681,
      1.544570,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.352500,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.087555,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.169348,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0.131058,
      0.180067,
      0.706317,
      2,
      3,
      '23400',
      NULL,
      '',
      0,
      '',
      '',
      '',
      NULL,
      '4010',
      '00013',
      '34302',
      3.314264,
      1.844968,
      3.039473,
      1.035691,
      0,
      3.816632,
      1,
      1.998495,
      3);
commit;
end;
/


