set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7736166';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-9-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2133',
      '20213114',
      61.151141,
      NULL,
      '4142032',
      145,
      NULL,
      1,
      0,
      '143030',
      0,
      ' 6- 1-1990',
      19.249600,
      30.332444,
      1,
      NULL,
      0.760902,
      1.462562,
      NULL,
      0,
      NULL,
      0.535233,
      0.173151,
      0.597339,
      1.843606,
      NULL,
      0,
      NULL,
      0,
      1.837859,
      NULL,
      0.150324,
      1,
      NULL,
      NULL,
      1,
      2,
      NULL,
      5.821707,
      0,
      NULL,
      1.384361,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0.833148,
      0.698925,
      3,
      1.122575,
      0,
      NULL,
      3.303499,
      0.295355,
      0.430509,
      1.689468,
      1.076854,
      1.140214,
      NULL,
      0,
      NULL,
      1,
      0.758568,
      0,
      3.892640,
      NULL,
      0,
      2.764206,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      0.073562,
      1,
      1.736782,
      NULL,
      1,
      0.802597,
      1.167716,
      1.973829,
      0,
      0,
      1.227412,
      NULL,
      1,
      1,
      0.836812,
      1,
      0,
      NULL,
      1.040437,
      NULL,
      NULL,
      NULL,
      0.780906,
      1.314282,
      0,
      3.998763,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2,
      0,
      0.064152,
      0,
      1.748492,
      8.314302,
      6.307462,
      5.747537,
      0,
      1.303250,
      4,
      NULL,
      2.503691,
      4,
      3.010320,
      NULL,
      0,
      4.423416,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.036289,
      1,
      0,
      NULL,
      1.848589,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.675847,
      NULL,
      NULL,
      0.135335,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      2.167026,
      0,
      7,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      6.405690,
      0.660119,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.693473,
      0.341868,
      1,
      3,
      NULL,
      NULL,
      2.661030,
      1.707406,
      0,
      2,
      0,
      0.462812,
      0,
      1,
      1,
      NULL,
      0,
      0.804065,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.043159,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.506036,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      1,
      NULL,
      0.754188,
      0.987739,
      0,
      2,
      0,
      '40442',
      '12420',
      '',
      1.797380,
      '',
      NULL,
      '',
      7,
      '22424',
      '01144',
      '1011',
      5,
      NULL,
      3,
      3,
      2,
      0.106970,
      3.415388,
      2,
      NULL);
commit;
end;
/


